#!NETQUOTEVAR:PERLPATH  

#?use CGI::Carp qw(fatalsToBrowser);

#
# Make sure "." is included in the @INC directory list so we can find our packages
#
my $bFound = 0;
my $sDir;
foreach $sDir (@INC)
	{
	if ($sDir eq ".")
		{
		$bFound = 1;
		last;
		}
	}
if (!$bFound)
	{
	push (@INC, ".");
	}
#
# NT systems rarely execute the CGI scripts in the cgi-bin, so attempt to locate
# the packages in that case.  This may still fail if the cgi-bin folder is named
# something else, but at least we will catch 80% of the cases.  The INCLUDEPATHADJUSMENT
# covers the remaining cases.
#
push (@INC, "cgi-bin");
NETQUOTEVAR:INCLUDEPATHADJUSTMENT

require NETQUOTEVAR:ACTINICPACKAGE;
require NETQUOTEVAR:ACTINICORDER;

use strict;

#######################################################
#                                                     #
# The above is the Path to Perl on the ISP's server   #
#                                                     #
# Requires Perl version 5.002 or later                #
#                                                     #
#######################################################

#######################################################
#                                                     #
# CATALOG SHOPPING CART CGI/PERL SCRIPT               #
#                                                     #
# Copyright (c) 1997 ACTINIC SOFTWARE LIMITED         #
#                                                     #
# written by George Menyhert                          #
#                                                     #
#######################################################

Init();														# initialize the global constants and data structures

DispatchCommands();										# process the commands

exit;
	 
##############################################################################################################
#																		
# Command Processing - Begin
#
##############################################################################################################

#######################################################
#																		
# DispatchCommands - parse the command input and
#	call the command processing function
#
# Expects:	%g_InputHash, and %g_SetupBlob
#					should be defined
#
#######################################################

sub DispatchCommands
	{
	my (@Response, $Status, $Message, $sHTML, $sAction, $sCartID);
	$::g_sCurrentPage = $::g_InputHash{"PAGE"};			# identify the calling page
	$sAction = $::g_InputHash{"ACTION"};				# check the page action

	#
	# static pages call the shopping cart page via ?ACTION=SHOWCART
	# static pages call the active X order control page via ?ACTION=ORDERACTIVEX
	# static pages call the Java order control page via ?ACTION=ORDERJAVA
	# 
	# All other queries are page specific.
	#

	my ($key, $value);
	if ($sAction eq "SHOWCART")						# display the shopping cart - this is a
		{
		@Response = ShowCart();
		($Status, $Message, $sHTML, $sCartID) = @Response; # parse the response
		if ($Status != $::SUCCESS)
			{
			ACTINIC::ReportError($Message, ACTINIC::GetPath());
			exit;
			}
		PrintPage($sHTML, $sCartID);
		}
	elsif ($::g_sCurrentPage eq "CONFIRMREMOVE")		# the call was made from a "confirm remove item" page
		{
		while (($key, $value) = each %::g_InputHash)	# locate the command button
			{
			if ($value =~ /$::g_sConfirmButtonLabel/ ||	# found the "Confirm" button
				 $value =~ /$::g_sCancelButtonLabel/)		# or the "Cancel" button
				{
				my ($Temp);
				$Temp = keys %::g_InputHash;				# reset the iterator for "each"
				last;
				}
			}
		if ($value eq $::g_sConfirmButtonLabel)
			{
			@Response = RemoveItem();					# remove the item from the cart and redisplay the cart
			($Status, $Message, $sHTML, $sCartID) = @Response; # parse the response
			if ($Status != $::SUCCESS)
				{
				ACTINIC::ReportError($Message, ACTINIC::GetPath());
				exit;
				}
			PrintPage($sHTML, $sCartID);
			}
		else
			{
			@Response = ReturnToLastPage(0, "", "");	# just redisplay the cart
			($Status, $Message, $sHTML) = @Response; # parse the response
			if ($Status != $::SUCCESS)
				{
				ACTINIC::ReportError($Message, ACTINIC::GetPath());
				exit;
				}
			PrintPage($sHTML);
			}	
		}
	elsif ($::g_sCurrentPage eq "SHOPPINGCART")		# the call was made from a shopping cart page
		{
		while (($key, $value) = each %::g_InputHash)	# locate the command button
			{
			if ($value =~ /$::g_sRemoveButtonLabel/ ||	# found the "Remove" button
				 $value =~ /$::g_sEditButtonLabel/)		# or the "Edit" button
				{
				my ($Temp);
				$Temp = keys %::g_InputHash;				# reset the iterator for "each"
				last;
				}
			}
		if ($value eq $::g_sRemoveButtonLabel)
			{
			@Response = ConfirmRemove();				# display a "Confirm remove" window
			}
		else
			{
			@Response = EditItem();						# edit the specified cart item
			}
		
		($Status, $Message, $sHTML, $sCartID) = @Response; # parse the response
		if ($Status != $::SUCCESS)
			{
			ACTINIC::ReportError($Message, ACTINIC::GetPath());
			exit;
			}
		PrintPage($sHTML, $sCartID);
		}
	elsif ($::g_sCurrentPage eq "PRODUCT")			# the call was made from a product page which means - add item to cart
		{
		@Response = OrderDetails($::FALSE);			# prompt the customer for order details
		($Status, $Message, $sHTML, $sCartID) = @Response;	# parse the response
		if ($Status != $::SUCCESS)
			{
			ACTINIC::ReportError($Message, ACTINIC::GetPath());
			exit;
			}
		PrintPage($sHTML, $sCartID);
		}
	elsif ($::g_sCurrentPage eq "ORDERDETAIL")		# the call was made from the order detail page
		{
		
		if ($sAction eq $::g_sCancelButtonLabel)		# Cancel the add
			{
			@Response = ReturnToLastPage(0, "", "");	# bounce back in the broswer
			($Status, $Message, $sHTML) = @Response;	# parse the response
			if ($Status != $::SUCCESS)
				{
				ACTINIC::ReportError($Message, ACTINIC::GetPath());
				exit;
				}
			PrintPage($sHTML);
			}
		
		else													# Confirm the add (or confirm and checkout now)
		# elsif ($sAction eq "Confirm") no longer used since the user could hit <CR> to confirm or do a checkout now
			{
			if ($#::g_PageList == 1 ||					# true when the adding an item to cart (only one page is the history list)
				!defined $::g_InputHash{"ITEMINDEX"})
				{
				@Response = AddToCart();				# add the item to the cart
				($Status, $Message, $sHTML, $sCartID) = @Response; # parse the response
				if ($Status != $::SUCCESS)
					{
					ACTINIC::ReportError($Message, ACTINIC::GetPath());
					exit;
					}
				PrintPage($sHTML, $sCartID);			# print the page and set the cookie
				}
			else												# called by the shopping cart page - edit mode
				{
				@Response = ChangeCartItem();			# change the item in the cart
				($Status, $Message, $sHTML, $sCartID) = @Response; # parse the response
				if ($Status != $::SUCCESS)
					{
					ACTINIC::ReportError($Message, ACTINIC::GetPath());
					exit;
				}
				PrintPage($sHTML, $sCartID);			# print the page and set the cookie
				}
			}
		}
	}

#######################################################
#																		
# ConfirmRemove - display a window to confirm that the
#	customer wants to remove the item from the cart
#
# Expects:	%::g_InputHash, and %g_SetupBlob
#					should be defined
#
# Returns:	($ReturnCode, $Error, $sHTML, $sCartID)
#				if $ReturnCode = $::FAILURE, the operation failed
#					for the reason specified in $Error
#				Otherwise everything is OK
#				$sHTML - the HTML of the order detail page
#				$sCartID - the cart id
#
#######################################################

sub ConfirmRemove
	{
	no strict 'refs';
	######
	# the name of the "Remove" button is the cart item number of interest
	######
	my ($bFound, $key, $value, $nItemIndex);
	$bFound = $::FALSE;
	while (($key, $value) = each %::g_InputHash)		# locate the "Remove" button
		{
		if ($value =~ /$::g_sRemoveButtonLabel/)			# found the "Remove" button
			{
			$bFound = $::TRUE;
			my ($Temp);
			$Temp = keys %::g_InputHash;					# reset the iterator for "each"
			$Temp = $Temp;									# removed compiler warning
			$nItemIndex = $key;
			last;
			}
		}

	my (%VariableTable, $sLine);
	
	$sLine = "<INPUT TYPE=HIDDEN NAME=\"PAGE\" VALUE=\"CONFIRMREMOVE\">\n";
	$VariableTable{$::VARPREFIX."PAGE"} = $sLine;	# add the page name

	my (@Response, $Status, $Message, $sCartID, $pCartList);
	
	@Response = ActinicOrder::GetCartID(ACTINIC::GetPath()); # retrieve the cart ID
	($Status, $Message, $sCartID) = @Response;
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}
	
	@Response = ActinicOrder::ReadCart($sCartID, ACTINIC::GetPath()); # read the shopping cart
	($Status, $Message, $pCartList) = @Response;
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}

	my (%CartItem);
	%CartItem = %{ $$pCartList[$nItemIndex] };	# retrieve the item of interest	
	#
	# Locate this product's object.
	#
	my ($sSectionBlobName);
	($Status, $Message, $sSectionBlobName) = ACTINIC::GetSectionBlobName($CartItem{SID}); # retrieve the blob name
	if ($Status == $::FAILURE)
		{
		return ($Status, $Message);
		}
	my ($pProduct);
	my $bDeleted = $::FALSE;
	@Response = ACTINIC::GetProduct($CartItem{"PRODUCT_REFERENCE"},  $sSectionBlobName,
		ACTINIC::GetPath());						# get this product object
	($Status, $Message, $pProduct) = @Response;
	if ($Status == $::NOTFOUND)						# the item has been removed from the catalog
		{
		# no-op, deleted product works fine here
		$bDeleted = $::TRUE;
		}
	if ($Status == $::FAILURE)
		{
		return (@Response);
		}
	
	my $spPrice;
	$spPrice = ActinicOrder::CalculateSchPrice($pProduct,$CartItem{"QUANTITY"},$ACTINIC::B2B->Get('UserDigest'));

	my $ComponentPrice = 0;
	#
	# Check if there are any variants
	#
	if( $pProduct->{COMPONENTS} )
		{
		my ($VariantList, $k);
		foreach $k (keys %CartItem)
			{
			if( $k =~ /^COMPONENT\_/ )
				{
				$VariantList->[$'] = $CartItem{$k};
				}
			}
		
		my (%Component, $c);
		foreach $c (@{$pProduct->{COMPONENTS}})
			{
			@Response = ActinicOrder::FindComponent($c,$VariantList);
			($Status, %Component) = @Response;
			if ($Status != $::SUCCESS)
				{
				return ($Status,$Component{text});
				}
			@Response = ActinicOrder::GetComponentPrice($Component{price},$CartItem{QUANTITY},$Component{quantity});
			if ($Response[0] != $::SUCCESS)	
				{
				return (@Response);
				}
			$ComponentPrice += $Response[2];
			}	
		}
	my $nPriceModel = $$pProduct{PRICING_MODEL};
	if( $nPriceModel == $ActinicOrder::PRICING_MODEL_PROD_COMP )
	 {
	 $spPrice += $ComponentPrice;
	 }
	elsif( $nPriceModel == $ActinicOrder::PRICING_MODEL_COMP )
	 {
	 $spPrice = $ComponentPrice;
	 }

	# product description
	my ($sDescription, $sProdRef);
	@Response = ACTINIC::ProcessEscapableText($$pProduct{"NAME"});# get the product name
	($Status, $sDescription) = @Response;			# format the product name for HTML
	if ($Status != $::SUCCESS)
		{
		return (@Response);
		}
	
	# product reference (optional)
	@Response = FormatProductReference($CartItem{"PRODUCT_REFERENCE"});
	($Status, $Message, $sProdRef) = @Response;
	if ($Status != $::SUCCESS)
		{
		return (@Response);
		}
		
	# Quantity
	my ($sFormat, $sQuantity);
	#
	# Use prompt field for formating
	#
	$sFormat = ACTINIC::GetPhrase(-1, 166) . ' <B>%d</B>';

	$sQuantity = sprintf($sFormat, $CartItem{"QUANTITY"});

	# price per item
	my ($sPrice);
	if(defined $pProduct)
		{
		if( $bDeleted )
			{
			$sPrice = '';
			}
		else
			{
			my $nRetailPrice = $$pProduct{PRICE};
			@Response = ActinicOrder::FormatCompletePrice($spPrice, $$pProduct{'TAX_1'}, 
				$$pProduct{'TAX_2'}, $nRetailPrice);
			($Status, $Message, $sPrice) = @Response;
			if ($Status != $::SUCCESS)
				{
				return (@Response);
				}
			if (length $sPrice > 0)
				{
				$sPrice .= "<BR>";
				}
			}
		}
	
	# total
	my ($nTotal, $sTotal);
	$nTotal = $CartItem{"QUANTITY"} * $spPrice; # calculate the order detail total
	#
	# we want to label this line with Total (-1, 103) rather than price
	#
	if(defined $pProduct)
		{
		if( $bDeleted )
			{
			$sTotal = '';
			}
		else
			{
			my $nRetailPrice = $$pProduct{PRICE};
			@Response = ActinicOrder::FormatCompletePrice($nTotal, $$pProduct{'TAX_1'}, $$pProduct{'TAX_2'}, $nRetailPrice, 103);
			($Status, $Message, $sTotal) = @Response;
			if ($Status != $::SUCCESS)
				{
				return (@Response);
				}
			}
		}
	$sTotal .= "<BR>";
	
	
	# optional date field
	my ($sDate);
	if (length $CartItem{"DATE"} > 0)			# if there is any date info
		{
		$sDate = $$pProduct{"DATE_PROMPT"};			# build the prompt
		$sDate .= " <B>";
		$sDate .= $CartItem{"DATE"};				# plus the response
		$sDate .= "</B><BR>";
		}
	
	# optional info field
	my ($sInfo);
	if (length $CartItem{"INFOINPUT"} > 0)		# if there is any info
		{
		$sInfo = $$pProduct{"OTHER_INFO_PROMPT"};	# build the prompt
		$sInfo .= " <B>";
		$sInfo .= $CartItem{"INFOINPUT"};		# plus the response
		$sInfo =~ s/%0a/<BR>/g;						# restore line feeds
		$sInfo .= "</B><BR>";
		}
	
	# build block
	$sLine = sprintf('<H2>%s%s</H2>%s%s%s%s<BR>%s<P>',
						  $sDescription, $sProdRef, $sDate, $sInfo, $sPrice, $sQuantity, $sTotal);
	
	$sLine .= ACTINIC::GetPhrase(-1, 46) . "<P>\n";
	# PRESNET
	# check if we want to display the Confirm button as an image
	#
	if (defined $$::g_pSetupBlob{'CONFIRM_IMG'} && $$::g_pSetupBlob{'CONFIRM_IMG'} ne '')
		{
		$sLine .= "<INPUT TYPE=IMAGE NAME=ACTION_CONFIRM VALUE=\"$::g_sConfirmButtonLabel\"";
		$sLine .= " ALT=\"$::g_sConfirmButtonLabel\" TITLE=\"$::g_sConfirmButtonLabel\"";
		$sLine .= " SRC=\"$$::g_pSetupBlob{'CONFIRM_IMG'}\"> \n";
		}
	else
		{
		$sLine .= "<INPUT TYPE=SUBMIT NAME=ACTION VALUE=\"$::g_sConfirmButtonLabel\"> \n";
		}

	#
	# check if we want to display the Cancel button as an image
	#
	if (defined $$::g_pSetupBlob{'CANCEL_IMG'} && $$::g_pSetupBlob{'CANCEL_IMG'} ne '')
		{
		$sLine .= "<INPUT TYPE=IMAGE NAME=ACTION_CANCEL VALUE=\"$::g_sCancelButtonLabel\"";
		$sLine .= " ALT=\"$::g_sCancelButtonLabel\" TITLE=\"$::g_sCancelButtonLabel\"";
		$sLine .= " SRC=\"$$::g_pSetupBlob{'CANCEL_IMG'}\"> <P> \n";
		}
	else
		{
		$sLine .= "<INPUT TYPE=SUBMIT NAME=ACTION VALUE=\"$::g_sCancelButtonLabel\"> <P>\n";
		}
	# PRESNET

	$sLine .= "<INPUT TYPE=HIDDEN NAME=ITEMINDEX VALUE=\"$nItemIndex\">\n";
	$VariableTable{$::VARPREFIX."BODY"} = $sLine;	# add the page name

	my ($sPath, $sHTML);
	$sPath = ACTINIC::GetPath();					# get the path to the web site dir
	
	@Response = ACTINIC::TemplateFile($sPath."CRTemplate.html", \%VariableTable); # make the substitutions
	($Status, $Message, $sHTML) = @Response;
	if ($Status != $::SUCCESS)
		{
		return (@Response);
		}

	#######
	# make the file references point to the correct directory
	#######
	if( !$ACTINIC::B2B->Get('UserDigest') )
		{
		@Response = ACTINIC::MakeLinksAbsolute($sHTML, $::g_sWebSiteUrl, $::g_sContentUrl);
		}
	else
		{
		my $sBaseFile = $ACTINIC::B2B->Get('BaseFile');
		my $smPath = ($sBaseFile) ? $sBaseFile : $::g_sContentUrl;
		my $sCgiUrl = $::g_sAccountScript;
		$sCgiUrl   .= ($::g_InputHash{SHOP} ? '?SHOP=' . ACTINIC::EncodeText2($::g_InputHash{SHOP}, $::FALSE) . '&' : '?');
		$sCgiUrl   .= 'PRODUCTPAGE=';
		@Response = ACTINIC::MakeLinksAbsolute($sHTML, $sCgiUrl, $smPath);
		}

	($Status, $Message, $sHTML) = @Response;
	if ($Status != $::SUCCESS)
		{
		return (@Response);
		}

 	return ($::SUCCESS, "", $sHTML, $sCartID);
	}

#######################################################
#																		
# ChangeCartItem - change the item in the cart
#
#	Confirm that the data is valid.  If so, add the item
#		to the cart.  If not, redisplay the order details
#		page with a message explaining the problems.
#
# Expects:	%::g_InputHash, and %g_SetupBlob
#					should be defined
#
# Returns:	($ReturnCode, $Error, $sHTML, $sCartID)
#				if $ReturnCode = $::FAILURE, the operation failed
#					for the reason specified in $Error
#				Otherwise everything is OK
#				$sHTML - the HTML of the order detail page
#				$sCartID - the cart id
#
#######################################################

sub ChangeCartItem
	{
	my ($Status, $Message, %OrderDetails, $nIndex, $sCartID, @Response);
	@Response = ActinicOrder::GetCartID(ACTINIC::GetPath()); # retrieve the cart ID
	($Status, $Message, $sCartID) = @Response;
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}
	($Status, $Message, %OrderDetails) =
	   ValidateOrderDetails($::TRUE);				# attempt to validate the data entered by the user

	$nIndex = $::g_InputHash{"ITEMINDEX"};				# get the cart index number for this item

	if ($Status == $::BADDATA)							# the data was invalid
		{
		my ($sSearch, $sReplace);
		$sSearch = "<INPUT TYPE=HIDDEN NAME=\"PAGE\"";
		$sReplace = "<INPUT TYPE=HIDDEN NAME=ITEMINDEX VALUE=\"$nIndex\">\n" .
		"<INPUT TYPE=HIDDEN NAME=\"PAGE\"";
		$Message =~ s/$sSearch/$sReplace/;			# insert the  item index value into the html
		
		return ($::SUCCESS, "", $Message, $sCartID); # but act like life was a ::SUCCESS - display the warning
		}
	elsif ($Status != $::SUCCESS)						# error while validating the data
		{
		return($Status, $Message, "", 0);			# return the error
		}
	
	#########
	# if we are here, the data is valid, change the item in the cart
	#########
	@Response = ActinicOrder::UpdateCartItem($sCartID, $nIndex, ACTINIC::GetPath(), \%OrderDetails);	# update the item
	($Status, $Message) = @Response;
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}
	
	@Response = ReturnToLastPage(0, "", "");		# bounce back in the broswer
	my ($sHTML);
	($Status, $Message, $sHTML) = @Response;		# parse the response
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}

	return ($::SUCCESS, "", $sHTML, $sCartID);
	}

#######################################################
#																		
# EdiItem - Edit the selected item in the cart
#
# Expects:	%::g_InputHash, and %g_SetupBlob
#					should be defined
#
# Returns:	($ReturnCode, $Error, $sHTML, $sCartID)
#				if $ReturnCode = $::FAILURE, the operation failed
#					for the reason specified in $Error
#				Otherwise everything is OK
#				$sHTML - the HTML of the order detail page
#				$sCartID - the cart id
#
#######################################################

sub EditItem
	{
	no strict 'refs';
	my ($sCartID, @Response, $Status, $Message, $key, $value);
	@Response = ActinicOrder::GetCartID(ACTINIC::GetPath()); # retrieve the cart ID
	($Status, $Message, $sCartID) = @Response;
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}

	######
	# the name of the "Edit" button is the cart item number of interest
	######
	my ($bFound, $nIndex);
	$bFound = $::FALSE;
	while (($key, $value) = each %::g_InputHash)		# locate the "Edit" button
		{
		if ($value =~ /$::g_sEditButtonLabel/)		# found the button
			{
			$nIndex = $key;								# store the index
			$bFound = $::TRUE;
			my ($Temp);
			$Temp = keys %::g_InputHash;					# reset the iterator for "each"
			$Temp = $Temp;									# removed compiler warning
			last;
			}
		}
	my ($pCartList);
	@Response = ActinicOrder::ReadCart($sCartID, ACTINIC::GetPath()); # read the shopping cart
	($Status, $Message, $pCartList) = @Response;
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}

	my (%CartItem);
	%CartItem = %{ $$pCartList[$nIndex] };			# retrieve the item of interest
	
	$::g_InputHash{"PRODREF"} =						# store the product reference in the input hash so order details
	   $CartItem{"PRODUCT_REFERENCE"};				# can retrieve it as if it came from the html form
	$::g_InputHash{"SID"} =								# store the product reference in the input hash so order details
	   $CartItem{"SID"};									# can retrieve it as if it came from the html form
					
	my ($nDay, $nMonth, $nYear);
	if (length $CartItem{"DATE"} > 0)				# if there was any data in the date field
		{
		$nDay = substr($CartItem{"DATE"}, 8, 2);	# retrieve the date components from the compiled date value
		$nMonth = substr($CartItem{"DATE"}, 5, 2); # which is in actinic internal format YYYY/MM/DD
		$nYear = substr($CartItem{"DATE"}, 0, 4);

		$nMonth = int $nMonth;							# get rid of any leading zero
		$nDay = int $nDay;								# get rid of any leading zero
		}	

	my ($sHTML);
	@Response = OrderDetails($::TRUE, $nDay, $nMonth, $nYear);	# rebuild the order detail page
	($Status, $Message, $sHTML, $sCartID) = @Response; # read the response
	if ($Status != $::SUCCESS)							# error out
		{
		return(@Response);
		}

	my ($sSearch, $sReplace);
	$sSearch = "<INPUT TYPE=HIDDEN NAME=\"PAGE\"";
	$sReplace = "<INPUT TYPE=HIDDEN NAME=ITEMINDEX VALUE=\"$nIndex\">\n" .
		 "<INPUT TYPE=HIDDEN NAME=\"PAGE\"";
	$sHTML =~ s/$sSearch/$sReplace/;					# insert the item index value into the html
	
	#########
	# insert the current values for the default values
	#########
	my (%Variables);
	if (length $CartItem{"INFOINPUT"} > 0)			# if there was any data in the info prompt
		{
		my ($sInfoValue);
		$sInfoValue = ACTINIC::EncodeText2($CartItem{"INFOINPUT"});		# retrieve the value
		$Variables{"NAME=INFOINPUT"} = "NAME=INFOINPUT VALUE=\"$sInfoValue\""; # make it the default for the next round
		}
	
	my ($nQuantity);
	$nQuantity = $CartItem{"QUANTITY"};
	$Variables{"NAME=QUANTITY VALUE=\"\\d+\""} =	# make the last quantity the default
	   "NAME=QUANTITY VALUE=\"$nQuantity\"";		# for the next round
	
	@Response = ACTINIC::TemplateString($sHTML, \%Variables); # make the substitutions
	($Status, $Message, $sHTML) = @Response;
	if ($Status != $::SUCCESS)
		{
		return (@Response);
		}

	return ($::SUCCESS, "", $sHTML, $sCartID);		# now display the order details
	}

#######################################################
#
# RemoveItem - remove the selected item from the cart
#	and redisplay the cart
#
# Expects:	%::g_InputHash, and %g_SetupBlob
#					should be defined
#
# Returns:	($ReturnCode, $Error, $sHTML, $sCartID)
#				if $ReturnCode = $::FAILURE, the operation failed
#					for the reason specified in $Error
#				Otherwise everything is OK
#				$sHTML - the HTML of the order detail page
#				$sCartID - the cart id
#
#######################################################

sub RemoveItem
	{
	my ($sCartID, @Response, $Status, $Message, $nItemIndex);
	@Response = ActinicOrder::GetCartID(ACTINIC::GetPath()); # retrieve the cart ID
	($Status, $Message, $sCartID) = @Response;
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}

	@Response = ActinicOrder::RemoveItemFromCart($sCartID, $::g_InputHash{"ITEMINDEX"}, ACTINIC::GetPath()); # remove item from cart
	($Status, $Message) = @Response;
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}

	@Response = ReturnToLastPage(0, "", "");			# bounce back in the broswer
	my ($sHTML);
	($Status, $Message, $sHTML) = @Response;		# parse the response
	if ($Status != $::SUCCESS)
		{
		ACTINIC::ReportError($Message, ACTINIC::GetPath());
		exit;
		}
	
	return ($::SUCCESS, "", $sHTML, $sCartID);		# now redisplay the cart
	}

#######################################################
#																		
# ShowCart - display the shopping cart
#
# Expects:	%::g_InputHash, and %g_SetupBlob
#					should be defined
#
# Returns:	($ReturnCode, $Error, $sHTML, $sCartID)
#				if $ReturnCode = $::FAILURE, the operation failed
#					for the reason specified in $Error
#				Otherwise everything is OK
#				$sHTML - the HTML of the order detail page
#				$sCartID - the cart id
#
#######################################################

sub ShowCart
	{
	my ($sCartID, @Response, $Status, $Message);
	@Response = ActinicOrder::GetCartID(ACTINIC::GetPath()); # retrieve the cart ID
	($Status, $Message, $sCartID) = @Response;
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}
	my ($pCartList);
	@Response = ActinicOrder::ReadCart($sCartID, ACTINIC::GetPath()); # read the shopping cart
	($Status, $Message, $pCartList) = @Response;
	if ($Status != $::SUCCESS &&
		 $Status != $::EOF) # error out
		{
		return (@Response);
		}
	
	my ($sLine, %VariableTable);

	#######
	# add the page name to a hidden field in the HTML
	#######
	$sLine = "<INPUT TYPE=HIDDEN NAME=\"PAGE\" VALUE=\"SHOPPINGCART\">";	# define the page type
	$VariableTable{$::VARPREFIX."PAGE"} = $sLine;	# add the page type to the variable table

	#
	# add the shopping cart items
	#
	@Response = ActinicOrder::GenerateShoppingCartLines($pCartList, $::TRUE);
	if ($Response[0] != $::SUCCESS)
		{
		return (@Response);
		}
	my ($sBody) = $Response[2];
	#	
	# add "Back" link
	#
	my ($sBack, $sPrevPage, @sTemp);
	if(defined $$::g_pSetupBlob{'DISPLAY_CART_AFTER_CONFIRM'} &&
		$$::g_pSetupBlob{'DISPLAY_CART_AFTER_CONFIRM'})
		{
		$sPrevPage = ACTINIC::GetLastNonScript(\@::g_PageList);		  	# get the last page visited
		}
	else
		{
		$sPrevPage = $::g_PageList[$#::g_PageList];		  	# get the last page visited
		if( $sPrevPage =~ /\?$/ )									# CGI script called without arguments
			{
			my ($sBodyPage,$sFramePage) = ACTINIC::CAccCatalogBody();	# Get main Catalog page
			@Response = ACTINIC::ProcessEscapableText($sBodyPage);
			($Status, $sBodyPage) = @Response;
			if ($Status != $::SUCCESS)
				{
				return (@Response);
				}
			$sPrevPage .= "PRODUCTPAGE=$sBodyPage";
			}
		}
	
	if( ACTINIC::IsCatalogFramed() )
		{
		$sBack = '';
		}
	else
		{
		$sBack = "<P><A HREF=\"" . $sPrevPage . "\">" . ACTINIC::GetPhrase(-1, 47) . "</A><P>\n";
		}

	$sBody = $sBack . $sBody . $sBack;				# build the complete body
	
	$VariableTable{$::VARPREFIX."BODY"} = $sBody;	# add the body to the var list
	
	my ($sPath, $sHTML);
	$sPath = ACTINIC::GetPath();					# get the path to the web site dir

	@Response = ACTINIC::TemplateFile($sPath."SCTemplate.html", \%VariableTable); # make the substitutions
	($Status, $Message, $sHTML) = @Response;
	if ($Status != $::SUCCESS)
		{
		return (@Response);
		}
	
	#######
	# make the file references point to the correct directory
	#######
	if( !$ACTINIC::B2B->Get('UserDigest') )
		{
		@Response = ACTINIC::MakeLinksAbsolute($sHTML, $::g_sWebSiteUrl, $::g_sContentUrl);
		}
	else
		{
		my $sBaseFile = $ACTINIC::B2B->Get('BaseFile');
		my $smPath = ($sBaseFile) ? $sBaseFile : $::g_sContentUrl;
		my $sCgiUrl = $::g_sAccountScript;
		$sCgiUrl   .= ($::g_InputHash{SHOP} ? '?SHOP=' . ACTINIC::EncodeText2($::g_InputHash{SHOP}, $::FALSE) . '&' : '?');
		$sCgiUrl   .= 'PRODUCTPAGE=';
		@Response = ACTINIC::MakeLinksAbsolute($sHTML, $sCgiUrl, $smPath);
		}

	($Status, $Message, $sHTML) = @Response;
	if ($Status != $::SUCCESS)
		{
		return (@Response);
		}
	#
	# update the checkout link to pass along the website URL
	#
	my ($sPageList) = join ('|||', @::g_PageList);
	my ($sTemp, $sEncodedRef) = ACTINIC::EncodeText($sPageList, $::FALSE);	# do CGI encoding first
	($sTemp, $sEncodedRef) = ACTINIC::EncodeText($sEncodedRef);					# follow up with HTML encoding
	$sHTML =~ s/(\?ACTION=[^\"]*)/$1&REFPAGE=$sEncodedRef/gi; 
	return ($::SUCCESS, "", $sHTML, $sCartID);
	}

#######################################################
#																		
# AddToCart - add the item to the cart
#
#	Confirm that the data is valid.  If so, add the item
#		to the cart.  If not, redisplay the order details
#		page with a message explaining the problems.
#
# Expects:	%::g_InputHash, and %g_SetupBlob
#					should be defined
#
# Returns:	($ReturnCode, $Error, $sHTML, $sCartID)
#				if $ReturnCode = $::FAILURE, the operation failed
#					for the reason specified in $Error
#				Otherwise everything is OK
#				$sHTML - the HTML of the order detail page
#				$sCartID - the cart id
#
#######################################################

sub AddToCart
	{
	my ($Status, $Message, %OrderDetails, $sCartID, @Response);

	@Response = ActinicOrder::GetCartID(ACTINIC::GetPath()); # retrieve the cart ID
	($Status, $Message, $sCartID) = @Response;
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}
	
	($Status, $Message, %OrderDetails) =
	   ValidateOrderDetails($::FALSE);				# attempt to validate the data entered by the user

	if ($Status == $::BADDATA)							# the data was invalid
		{
		return ($::SUCCESS, "", $Message, $sCartID); # but act like life was a ::SUCCESS - display the warning
		}
	elsif ($Status != $::SUCCESS)						# error while validating the data
		{
		return($Status, $Message, "", 0);			# return the error
		}
	
	my ($nInitLineCount);
	@Response = ActinicOrder::CountCartItems($sCartID, ACTINIC::GetPath()); # count items in the cart before we add the new one
	($Status, $Message, $nInitLineCount) = @Response;
	if ($Status == $::FAILURE)							# error out
		{
		return (@Response);
		}
	
	#########
	# if we are here, the data is valid, add the item to the cart
	#########
	@Response = ActinicOrder::AddItemToCart($sCartID, ACTINIC::GetPath(), \%OrderDetails);	# add this data item to the cart
	($Status, $Message) = @Response;
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}
	
	my ($nLineCount);
	@Response = ActinicOrder::CountCartItems($sCartID, ACTINIC::GetPath()); # count the items in the cart
	($Status, $Message, $nLineCount) = @Response;
	if ($Status == $::FAILURE)							# error out
		{
		return (@Response);
		}
	
	if ($nLineCount != ($nInitLineCount + 1))		# make sure the line was added - this is done because the prints
		{														# don't seem to return a ::FAILURE
		return ($::FAILURE, ACTINIC::GetPhrase(-1, 49), 0, 0);
		}

	my ($sPageTitle, $sStatusMessage);
	$sPageTitle = '';
	if ($nLineCount > 1)									# be pluritically correct
		{
		$sStatusMessage = ACTINIC::GetPhrase(-1, 50, $nLineCount);
		}
	else
		{
		$sStatusMessage = ACTINIC::GetPhrase(-1, 168);
		}

	my ($sHTML);
	$sPageTitle = ACTINIC::GetPhrase(-1, 51);
	#
	# Presnet: check if we want to display the shopping cart contents after confirmation
	#
	if (defined $$::g_pSetupBlob{'DISPLAY_CART_AFTER_CONFIRM'} &&
		$$::g_pSetupBlob{'DISPLAY_CART_AFTER_CONFIRM'})
		{
		#
		# Display the cart contents with links
		#
		@Response = DisplayCartWithLinks($sCartID, $sPageTitle);
		($Status, $Message, $sHTML) = @Response;		# parse the response
		if ($Status != $::SUCCESS)							# error out
			{
			return (@Response);
			}
		}
	elsif ($::g_InputHash{ACTION} eq ACTINIC::GetPhrase(-1, 184))	# checkout now - bounce to the ordering screen
		{
		#
		# append the original URL to the checkout URL so it can find the images, etc.
		#
		@Response = ACTINIC::EncodeText($::g_PageList[0], $::FALSE);
		my $sDestinationUrl = $::g_InputHash{CHECKOUTURL} . "&ACTINIC_REFERRER=" . $Response[1];
		#
		# Check cart value for B2B
		#
		($Status, $sHTML) = ActinicOrder::CheckBuyerLimit($sCartID,$sDestinationUrl,$::FALSE);	# Check buyer cash limit
		if ($Status != $::SUCCESS)						# error out
			{
			return ($::SUCCESS,"",$sHTML,$sCartID);
			}

		#
		# now post the message and forward the browser
		#
		@Response = ACTINIC::BounceToPageEnhanced(2, "<FONT SIZE=+2><B>" . $sStatusMessage . "</B></FONT>",
			$sPageTitle, \@::g_PageList, $::g_sWebSiteUrl,
			$::g_sContentUrl, $::g_pSetupBlob,
			$sDestinationUrl, \%::g_InputHash, $$::g_pSetupBlob{UNFRAMED_CHECKOUT});	# bounce to the checkout screen in the broswer - NOTE that the last argument causes the browser to use javascript to clear the frames if necessary
		($Status, $Message, $sHTML) = @Response;		# parse the response
		if ($Status != $::SUCCESS)							# error out
			{
			return (@Response);
			}
		}
	else															# standard confirmation
		{
		@Response = ReturnToLastPage(2, "<FONT SIZE=+2><B>" .
			$sStatusMessage . "</B></FONT>",
			$sPageTitle);										# bounce back in the broswer
		($Status, $Message, $sHTML) = @Response;		# parse the response
		if ($Status != $::SUCCESS)							# error out
			{
			return (@Response);
			}
		}

	return ($::SUCCESS, "", $sHTML, $sCartID);
	}

#######################################################
#																		
# ValidateOrderDetails - Validate the order details.
#	If they are valid, return ::SUCCESS.  If any are
#	invalid, return ::BADDATA with a modified OrderDetails
#	page packed into $Error.  Can also return ::FAILURE
#	on unrecoverable error.
#
# Params:	0 - edit flag - if true we are editing
#					the item.  if false, we are adding it
#					for the first time
#
# Expects:	%::g_InputHash, and %g_SetupBlob
#					should be defined
#
# Returns:	0 - $ReturnCode
#				1 - $Error
#				2 - $pData (a reference to the order details)
#
#				if $ReturnCode = $::FAILURE, the operation failed
#					for the reason specified in $Error
#				else $ReturnCode = $::BADDATA then $Error contains
#					the order detail page HTML modified to
#					correct the order
#				else $::SUCCESS then $pData contains the data
#					the page
#
#######################################################

sub ValidateOrderDetails
	{
#? ACTINIC::ASSERT($#_ == 0, "Invalid argument count in ValidateOrderDetails ($#_)", __LINE__, __FILE__);
	my ($bEditMode) = @_;
	
	my ($bInfoExists, $bDateExists, $key, $value, $sMessage, %Values);
	$bInfoExists = $::FALSE;
	$bDateExists = $::FALSE;
	$sMessage = "";

	#
	# Validate the cookie exists
	#
	#
	# parse the cookie - look for the actinic cart
	my ($sCookie, $Status, $Message, @Response);
	$sCookie = ACTINIC::GetCookie();					# retrieve the actinic cart ID
	if (!defined $sCookie ||							# the cookie hasn't been set
		 length $sCookie == 0)
		{
		my ($sHTML);

		$sMessage = ACTINIC::GetPhrase(-1, 52) . "\n";
		($Status, $Message, $sHTML) = ReturnToLastPage(-1, $sMessage, ACTINIC::GetPhrase(-1, 53));
		
		return ($::BADDATA, $sHTML, 0, 0);				# bounce back in the broswer
		}
	
	#
	# Locate the product of interest
	#
	my ($ProductRef, $pProduct);
	$ProductRef = $::g_InputHash{"PRODREF"};
	if (length $ProductRef == 0)						# if the product reference was not found
		{
		return ($::FAILURE, ACTINIC::GetPhrase(-1, 54), 0, 0);
		}
	
	my ($sSectionBlobName);
	($Status, $Message, $sSectionBlobName) = ACTINIC::GetSectionBlobName($::g_InputHash{SID}); # retrieve the blob name
	if ($Status == $::FAILURE)
		{
		return ($Status, $Message);
		}
	@Response = ACTINIC::GetProduct($ProductRef, $sSectionBlobName,
		ACTINIC::GetPath());						# get this product object
	($Status, $Message, $pProduct) = @Response;
	#
	# items deleted from the catalog should error out here - they can't be tolerated at this point
	#
	if ($Status != $::SUCCESS)
		{
		return (@Response);
		}
   
	$bInfoExists = (length $$pProduct{"OTHER_INFO_PROMPT"} != 0); # see if the info field exists.
	$bDateExists = (length $$pProduct{"DATE_PROMPT"} != 0); # see if the date field exists

	$Values{'PRODUCT_REFERENCE'} = $ProductRef;	# store the product reference
	#
	# Check if there are any variants
	#
	if( $pProduct->{COMPONENTS} )
		{
		my $bGotHash = $::FALSE;
		my $k;
		foreach $k (keys %::g_InputHash)
			{
			if( $k =~ /^$ProductRef\_/ )
				{
				$Values{'COMPONENT_'.$'} = $::g_InputHash{$k};
				$bGotHash = $::TRUE;
				}
			}
		if( !$bGotHash and $bEditMode )
			{
			@Response = ActinicOrder::GetCartID(ACTINIC::GetPath()); # retrieve the cart ID
			if ($Response[0] != $::SUCCESS)							# error out
				{
				return (@Response);
				}
			my ($sCartID) = $Response[2];
			my ($pCartList, @EmptyArray);
			@Response = ActinicOrder::ReadCart($sCartID, ACTINIC::GetPath()); # read the shopping cart
			if ($Response[0] != $::SUCCESS)						# general error
				{
				$pCartList = \@EmptyArray;
				}
			else
				{
				$pCartList = $Response[2];
				}
			my $i = 0;
			my $pOrderDetail;
			foreach $pOrderDetail (@$pCartList)
				{
				my %CurrentItem = %$pOrderDetail;				# get the next item
				if( $CurrentItem{PRODUCT_REFERENCE} eq $ProductRef and $i == $::g_InputHash{ITEMINDEX})
					{
					my $k;
					foreach $k (keys %CurrentItem)
						{
						if( $k =~ /^COMPONENT\_/ )
							{
							$Values{'COMPONENT_'.$'} = $CurrentItem{$k};
							}
						}
					last;
					}
				$i++;
				}
			}
		}
	my ($sInfo);
	if ($bInfoExists)										# if the info prompt exists, it must contain data
		{
		$sInfo = $::g_InputHash{"INFOINPUT"};
		if (length $sInfo == 0)							# if there is no info, reprompt
			{
			my ($sPrompt);
			$sPrompt = $$pProduct{"OTHER_INFO_PROMPT"};
			$sMessage .= ACTINIC::GetPhrase(-1, 55, "<B>$sPrompt</B>") . "<P>\n";
			}
		elsif (length $sInfo > 1000)
			{
			my ($sPrompt);
			$sPrompt = $$pProduct{"OTHER_INFO_PROMPT"};
			$sMessage .= ACTINIC::GetPhrase(-1, 56, "<B>$sPrompt</B>") . "<P>\n";
			}
		$sInfo =~ s/\n/%0a/g;							# Preserve new lines
		$Values{"INFOINPUT"} = $sInfo;
		}

	my ($nDay, $sMonth, $nMonth, $nYear, $bBad);
	$bBad = $::FALSE;
	if ($bDateExists)										# if the date prompt exists, confirm that the date isn't wacky
		{
		$nDay = $::g_InputHash{"DAY"};				# get the day,
		$sMonth = $::g_InputHash{"MONTH"};			# month,
		$nYear = $::g_InputHash{"YEAR"};				# and year fields

		$nMonth = $::g_MonthMap{$sMonth};			# convert the month to a digit for later use

		#######
		# NOTE: the UI limits the day input to 1-31, so there is no need to check the majority of the months
		#######
		if ( ($sMonth eq $::g_InverseMonthMap{'4'} ||		# 30 day months (April, June, September, November)
				$sMonth eq $::g_InverseMonthMap{'6'} ||
				$sMonth eq $::g_InverseMonthMap{'9'} ||
				$sMonth eq $::g_InverseMonthMap{'11'})  &&
			  $nDay > 30)
			{
			$bBad = $::TRUE;
			}

		elsif ($sMonth eq $::g_InverseMonthMap{'2'})			# 28/29 day month
			{
			if ($nDay > 29)								# if the day is more than 29
				{
				$bBad = $::TRUE;								# definitely a problem
				}
			elsif ($nDay == 29)							# if the day is exactly 29
				{
				if ($nYear % 400 == 0)					# if this is the fourth century
					{
																# no-op, leap year is OK on years divisible by 400
					}
				elsif ($nYear % 100 == 0)				# if the is century 1-3
					{
					$bBad = $::TRUE;							# leap year is skipped on 3 out of the 4 century years
					}
				elsif ($nYear % 4 == 0)					# this is not a century, but is divisble by 4
					{
																# no-op, leap year OK
					}
				else											# all other years, leap year bad
					{
					$bBad = $::TRUE;							# leap year is skipped on 3 out of the 4 years
					}
				}
			else												# 28 days or less
				{
																# no-op, OK
				}
			}

		my $sPrompt = $$pProduct{"DATE_PROMPT"};		# warn and reprompt
		if (length $nDay == 0 ||						# if any of the date fields are undefined
			 length $sMonth == 0 ||
			 length $nYear == 0)
			{
			$sMessage .= ACTINIC::GetPhrase(-1, 57, "<B>$sPrompt</B>") . "<P>\n";
			}
		elsif ($bBad)										# an error was found
			{
			$sMessage .= ACTINIC::GetPhrase(-1, 58, "<B>$sPrompt</B>") . "<P>\n";
			}
		$Values{"DATE"} = sprintf("%4.4d/%2.2d/%2.2d", $nYear, $nMonth, $nDay);	# store the value
		}

	my ($nIndex);
	$nIndex = -1;
	if ($#::g_PageList != 1)								# if this is validation for an "Edit"
		{														# compensate for the value already stored in the cart

		$nIndex = $::g_InputHash{"ITEMINDEX"};			# get the cart index number for this item
		}
	
	my ($nQuantity, $nMaxQuantity, $nMinQuantity);
	$nMinQuantity = $$pProduct{"MIN_QUANTITY_ORDERABLE"}; # get the min quantity count.  this is maintained on a per
																# order detail basis

	if ($nIndex == -1)									# we are not editing an item, so get the max allowable
		{
		($Status, $Message, $nMaxQuantity) =
	      GetMaxRemains($ProductRef, $sSectionBlobName);	# calculate the maximum quantity of this item that can be added to the cart
		}
	else														# we are editing an item, so get the max allowable, but compensate for
		{														# the fact that we are changing an item already in the cart
		($Status, $Message, $nMaxQuantity) =
	      GetMaxRemains($ProductRef, $sSectionBlobName, $nIndex);	# calculate the maximum quantity of this item that can be added to the cart
		}
	if ($Status != $::SUCCESS)
		{
		return($Status, $Message, 0, 0);
		}

   $nMinQuantity -= ($pProduct->{MAX_QUANTITY_ORDERABLE} - $nMaxQuantity); # adjust the min quantity for items already in the cart (if any)
   if ($nMinQuantity < 1)								# keep the min reasonable
		{
		$nMinQuantity = 1;
		}

	$nQuantity = $::g_InputHash{"QUANTITY"};			# retrieve the quantity ordered
	$nQuantity =~ s/^\s//g;								# strip any leading white space
	$nQuantity =~ s/\s$//g;								# strip any trailing white space
	
	if ($nMaxQuantity == 0)								# if there is no limit on the quantity count
		{
		$nMaxQuantity = 32767;							# it is still limited by the size of the quantity container
		}
		
	if( $nMinQuantity > $nMaxQuantity )				# There is a minimum and maximum and there is already some
		{
		$nMinQuantity = 1;
		}
	if ($nMaxQuantity == -1)							# sold out
		{
		$sMessage .= ACTINIC::GetPhrase(-1, 59) . "<P>\n";
		}
	elsif ($nQuantity =~ /\D/ ||						# if there are any non-digits in the quantity
			 $nQuantity < $nMinQuantity  ||			# or the quantity is not >= min quantity
			 ($nMaxQuantity != 0 &&						# or ( the quantity ordered is more than the quantity allowed)
			  $nQuantity > $nMaxQuantity) )
		{
		if ($nMaxQuantity > 1)
			{
			$sMessage .= ACTINIC::GetPhrase(-1, 60, $nMinQuantity, $nMaxQuantity) . "<P>\n";
			}
		elsif ($nMaxQuantity == 1)
			{
			$sMessage .= ACTINIC::GetPhrase(-1, 61) . "<P>\n";
			}
		elsif ($nMaxQuantity == 0)
			{
			$sMessage .= ACTINIC::GetPhrase(-1, 62, $nMinQuantity) . "<P>\n";
			}
		}

	$Values{"QUANTITY"} = $nQuantity;				# store the quantity
	
	$Values{SID} = $::g_InputHash{SID}; # store the section blob
	#
	# Validate the shipping and tax info if it exists
	#
	if ($$::g_pSetupBlob{'TAX_AND_SHIP_EARLY'})
		{
		$sMessage .= ActinicOrder::ValidatePreliminaryInfo($::TRUE);
		$sMessage .= ActinicOrder::ValidateTax($::TRUE, $::FALSE);
		}
		
	if (length $sMessage > 0)							# there was a problem with at least one of the fields
		{

		$sMessage = "<TABLE CELLPADDING=\"10\" WIDTH=\"550\" BORDER=\"1\" BGCOLOR=\"$$::g_pSetupBlob{FORM_BACKGROUND_COLOR}\">" .
			"<TR><TD><BIG> $sMessage</BIG></TD></TR></TABLE><P><HR>";
		
		my ($sHTML, $sCartID);
		@Response = OrderDetails($bEditMode, $nDay, $nMonth, $nYear);	# rebuild the order detail page
		($Status, $Message, $sHTML, $sCartID) = @Response;	# read the response
		if ($Status != $::SUCCESS)						# error out
			{
			return(@Response);
			}

		#########
		# insert the old values for the default values
		#########
		my (%Variables);
		if (length $Values{"INFOINPUT"} > 0)		# if there was any data in the info prompt
			{
			my ($sInfoValue);
			$sInfoValue = $Values{"INFOINPUT"};		# retrieve the value
			$sInfoValue =~ s/%0a/\n/g;					# Restore new lines
			$Variables{"NAME=INFOINPUT"} = "NAME=INFOINPUT VALUE=\"$sInfoValue\""; # make it the default for the next round
			}
		
		$Variables{"NAME=QUANTITY VALUE=\"\\d+\""} = # make the last quantity the default
		   "NAME=QUANTITY VALUE=\"$nQuantity\"";	# for the next round

		$Variables{"<INPUT TYPE=HIDDEN NAME=\"PAGE\""} =	# add the message at the top of the page
		   $sMessage."<INPUT TYPE=HIDDEN NAME=\"PAGE\"";
		
		@Response = ACTINIC::TemplateString($sHTML, \%Variables); # make the substitutions
		($Status, $Message, $sHTML) = @Response;
		if ($Status != $::SUCCESS)
			{
			return (@Response);
			}

		pop @::g_PageList;									# remove the extra page from the list (the last order details page)

		return ($::BADDATA, $sHTML, 0, 0);				# return notifying that the data was incorrect
		}
	else														# the data is valid, record its values
		{
		#
		# save the modified data
		#
		@Response = ActinicOrder::GetCartID(ACTINIC::GetPath()); # retrieve the cart ID
		if ($Response[0] != $::SUCCESS)							# error out
			{
			return (@Response);
			}
		my ($sCartID) = $Response[2];
		my (%EmptyPaymentInfo);
		#
		# Save the payment method
		#
		$EmptyPaymentInfo{'METHOD'} 		= $::g_PaymentInfo{'METHOD'};
		#
		# If we are in B2B mode, save the account price schedule
		#
		if( $ACTINIC::B2B->Get('UserDigest') )
			{
			$EmptyPaymentInfo{'SCHEDULE'} 		= $::g_PaymentInfo{'SCHEDULE'};
			}
		@Response = ActinicOrder::SaveCheckoutStatus(ACTINIC::GetPath(), $sCartID, \%::g_BillContact,
											\%::g_ShipContact, \%::g_ShipInfo, \%::g_TaxInfo, \%::g_GeneralInfo,
											\%EmptyPaymentInfo, \%::g_LocationInfo);
		if ($Response[0] != $::SUCCESS)
			{
			return ($Response[0], $Response[1], 0, 0);
			}
											
		return ($::SUCCESS, "", %Values);				# return the values
		}

	return ($::FAILURE, "Should never get here (ValidateData)", 0, 0);
	}

#######################################################
#																		
# GetMaxRemains - Calculate the maximum number of items
#  orderable.
#
# Params:	[0] - product ref
#				[1] - section blob name
#				[2] - (optional) index of item in cart
#						that is being edited
#
# Returns:	($ReturnCode, $Error, $nQuantity)
#				if $ReturnCode = $::FAILURE, the operation failed
#					for the reason specified in $Error
#				else $::SUCCESS then $nQuantity contains
#					-1 - no more items can be ordered
#					0 - no limit on items count
#					N - (positive) max number of items
#						that can be ordered
#
#######################################################

sub GetMaxRemains
	{
	no strict 'refs';
	if ($#_ < 1)
		{
		return ($::FAILURE, ACTINIC::GetPhrase(-1, 12, 'GetMaxRemains'), 0, 0);
		}

	my (@Response, $Status, $Message, $sCartID, $ProductRef, $Product, $nIndex, $sSectionBlob);
	$ProductRef = $_[0];
	$sSectionBlob = $_[1];
	if (defined $_[2])
		{
		$nIndex = $_[2];
		}
	else
		{
		$nIndex = -1;
		}
	
	@Response = ACTINIC::GetProduct($ProductRef, $sSectionBlob,
		ACTINIC::GetPath());							# get this product object
	my ($pProduct);
	($Status, $Message, $pProduct) = @Response;
	if ($Status == $::NOTFOUND)						# the item has been removed from the catalog
		{
		# no-op, deleted product works fine here
		}
	if ($Status == $::FAILURE)
		{
		return (@Response);
		}

	if ($$pProduct{'MAX_QUANTITY_ORDERABLE'} == 0)	# if there is no limit on the quantity ordered
		{
		return ($::SUCCESS, "", 0, 0);					# pass it along
		}
   
	@Response = ActinicOrder::GetCartID(ACTINIC::GetPath()); # retrieve the cart ID
	($Status, $Message, $sCartID) = @Response;
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}

	my ($pCartList);
	@Response = ActinicOrder::ReadCart($sCartID, ACTINIC::GetPath()); # read the shopping cart
	($Status, $Message, $pCartList) = @Response;
	if ($Status == $::EOF)								# no cart
		{
		return($::SUCCESS, "", $$pProduct{'MAX_QUANTITY_ORDERABLE'}, 0);
		}
	elsif ($Status != $::SUCCESS)						# general error
		{
		return(@Response);
		}

	my ($OrderDetail, %CurrentItem, $nQuantityLeft, $nCartItemIndex);
	$nQuantityLeft = $$pProduct{'MAX_QUANTITY_ORDERABLE'};
	$nCartItemIndex = -1;								# index of the current cart item
	foreach $OrderDetail (@$pCartList)				# review all of the items in the cart
		{
		%CurrentItem = %$OrderDetail;					# get the next item

		$nCartItemIndex++;								# keep track of the current item index

		if ($nCartItemIndex == $nIndex)				# if this item is the one being edited,
			{
			next;												# skip it
			}
		
		if ($CurrentItem{'PRODUCT_REFERENCE'} eq $ProductRef)	# if this cart item matches the selected product
			{
			$nQuantityLeft -= $CurrentItem{'QUANTITY'};	# sum the total items ordered
			}
		}

	if ($nQuantityLeft <= 0)							# if the max is already bought,
		{
		$nQuantityLeft = -1;								# -1 indicates no more
		}

	return ($::SUCCESS, "", $nQuantityLeft, 0);
	}

#######################################################
#																		
# OrderDetails - display the details of this
#	 order line
#
# Params:	0 - edit flag - if true we are editing
#					the item.  if false, we are adding it
#					for the first time
#				1 - the default day (optional)
#				2 - the default month (optional)
#				3 - the default year (optional)
#
# Returns:	($ReturnCode, $Error, $sHTML, 0)
#				if $ReturnCode = $::FAILURE, the operation failed
#					for the reason specified in $Error
#				Otherwise everything is OK
#				$sHTML - the HTML of the order detail page
#
#######################################################

sub OrderDetails
	{
#? ACTINIC::ASSERT($#_ >= 0, "Invalid argument count in OrderDetails ($#_)", __LINE__, __FILE__);

	my ($bEditMode, @Date) = @_;							# get the edit mode and default date (if any)
	
	my ($sPath, $bStandAlonePage);
	$sPath = ACTINIC::GetPath();						# get the path to the web site dir

	my ($sLine, %VariableTable);

	#######
	# add the product reference to a hidden field in the HTML
	#######
	my ($ProductRef, $key, $value);
  
	foreach (keys %::g_InputHash)		# New variants - 'add' button is '_' followed bu prodref
		{
		if( $_ =~ /^_/ )
			{
			$ProductRef = $';
			$ProductRef =~ s/\.[xy]$//;
			$ProductRef =~ s/_.*//g;
			last;
			}
		}
	#
	# Locate the appropriate section
	#
	my ($Status, $Message, $sSectionBlobName) = ACTINIC::GetSectionBlobName($::g_InputHash{SID}); # retrieve the blob name
	if ($Status == $::FAILURE)
		{
		return ($Status, $Message);
		}

	my ($sImageButtonName, $sSuffix);
	if( !$ProductRef ) { $ProductRef = $::g_InputHash{"PRODREF"}; }
	if (length $ProductRef == 0)						# if the product reference was not found
		{
		while (($key, $value) = each %::g_InputHash)	# locate the product reference
			{
			if (length $::g_sAddToButtonLabel > 0 && 	# found the add to cart button identified by the button
				 $value =~ /\Q$::g_sAddToButtonLabel\E/ &&	# label and a key that does not contain "_".  "_" indicates
				 $key !~ /_/)									# that this button is used for variants (and is processed below)
				{
				$ProductRef = $key;						# store the product reference
				last;
				}
			#
			# If it was an Image button, we don't seem to get the "Add To" value
			# so we have to look for something that looks like a coordinate
			# This will simply be the button name followed by ".x" or ".y"
			#
			if ($key =~ /(.+)\.([xy])$/ &&					# Looks like an image co-ordinate, but we must rule out
				 $key !~ /_/)								# product variants (handled below)
				{
				#
				# We have something that ends in .x or .y.  If both are present
				# we assume that this came from an IMAGE button
				#
				if($sImageButtonName)					# already found a .[xy] suffix?
					{
					if($sSuffix ne $2)					# and the suffix is different
						{
						($ProductRef) = $sImageButtonName;# use the de-suffixed name
						last;
						}
					}
				else											# first [xy] suffix
					{
					$sImageButtonName = $1;				# save the key without the suffix
					$sSuffix = $2;							# save the suffix
					}
				}
			#
			# if those attempts to locate the product reference fail, we are probably dealing with variants
			# Search for a variant definition.  When a variant has been selected, the variant button has a
			# NAME (hash key) of the form "ATB_<something>".  From the spec:
			#
			# For buttons used to submit the form, the NAME of the INPUT tag will be:
			#
			# ATB_<variant number>...
			#
			if ($key =~ /^ATB_/)
				{
				#
				# A variant has been selected.  There are two types of variants attribute controls:
				#
				#	1) A button in a matrix (0, 1, or 2 dimensional):  The button name can define 0-2 variant
				#		attribute values.  The button name is of the form:
				#
				# 		ATB_<variant number>[_<attribute number>_<attribute value number>[_<attribute number>_<attribute value number>]]
				#
				# 		Here, there are optional attribute/value pairs.
				#
				#	2) Drop down menus or radio buttons.  Attribute names are of the form:
				#
				#		AT_<variant number>_<attribute number> = <attribute value>
				#
				#	The resulting variant code is pieced together from the attributes.  It is of the form:
				#
				#		<variant number>[_<attribute number>_<attribute value number>][_<attribute number>_<attribute value number>]...
				#
				#	The variants are listed in ascending order.
				#
				#	Once the variant code is retrieved, the variant list for this section is used to resolve
				#	the code into a product reference.
				#
				#
				# First we strip the variant ID and attribute/values from the button (if any)
				#
				my ($sVariantCode, @Attributes);
				$key =~ /ATB_(\d+)([_0-9]*)/;
				my ($nVariantID, $sAttributePart) = ($1, $2);
				#
				# now pick apart the attributes
				#
				my ($nAttribute, $nValue);
				while (0 < length $sAttributePart)
					{
					$sAttributePart =~ /_(\d+)_(\d+)(.*)/;
					($nAttribute, $nValue, $sAttributePart) = ($1, $2, $3);
					$Attributes[($nAttribute-1)] = $nValue;
					}
				#
				# now search for other attributes in the input list
				#
				my @Keys = sort keys %::g_InputHash;
				my ($sName);
				my $sSearchString = "AT_" . $nVariantID . "_(\\d+)";
				foreach $sName (@Keys)					# check each input parameter
					{
					if ($sName =~ /$sSearchString/) # if this parameter is an attribute (format AT_<variant>_<att>_<value>)
						{
						$Attributes[($1-1)] = $::g_InputHash{$sName};	# store the pairs
						}
					}
				#
				# now build the variant code
				#
				$sVariantCode = $nVariantID . "_";
				foreach $nAttribute (@Attributes)
					{
					$sVariantCode .= $nAttribute . "_";
					}
				$sVariantCode =~ s/_$//;
				#
				# retrieve the product reference from the variant code
				#
#!				ACTINIC::ASSERT(length $sVariantCode >= 5, "Product variant code is corrupt.  Code length = " . (length $sVariantCode) . ".", __LINE__, __FILE__);
				my @Response = ACTINIC::GetProductReferenceFromVariant($sVariantCode, $sSectionBlobName, $sPath);
				if ($Response[0] != $::SUCCESS)
					{
					return (@Response);
					}
				$ProductRef = $Response[2];
				#
				#
				last;												# exit the loop at this point
				}
			}
			
		my ($Temp);
		$Temp = keys %::g_InputHash;						# reset the iterator for "each"
		$Temp = $Temp;											# remove compiler warning
		}
	if (!$ProductRef)										# if the product reference was not found
		{
		if( $sImageButtonName )
			{
			$ProductRef = $sImageButtonName;
			}
		else
			{
			return ($::FAILURE, ACTINIC::GetPhrase(-1, 54), 0, 0);
			}
		}

	my ($sCartID, $nMaxQuantity, @Response);
	@Response = ActinicOrder::GetCartID($sPath); # retrieve the cart ID
	($Status, $Message, $sCartID) = @Response;
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}

	if ($::g_sCurrentPage eq "PRODUCT")				# if this is the first viewing of the OD page,
		{
		($Status, $Message, $nMaxQuantity) =
	      GetMaxRemains($ProductRef, $sSectionBlobName);	# calculate the maximum quantity of this item that can be added to the cart
		if ($Status != $::SUCCESS)
			{
			return($Status, $Message, 0, 0);
			}
	   
		if ($nMaxQuantity == -1)						# if max quantity has been met (already sold out)
			{
			my ($sLocalPage, $sMessage);
			$sLocalPage = pop @::g_PageList;			# get the last item in the list
			push (@::g_PageList, $sLocalPage);		# put the item back
			push (@::g_PageList, $sLocalPage);		# dup the item (this allows us to bounce properly using ReturnToLastPage)
		
			$sMessage .= "<B>" . ACTINIC::GetPhrase(-1, 63) . "</B>";

			@Response = ReturnToLastPage(5, $sMessage, ACTINIC::GetPhrase(-1, 64));
			return ($Response[0], $Response[1], $Response[2], $sCartID);
			}
		}
	#
	# Now locate this product's object.  To do this, we must read the catalog blob
	#
	my ($pProduct);
	@Response = ACTINIC::GetProduct($ProductRef, $sSectionBlobName,
		$sPath);												# get this product object
	($Status, $Message, $pProduct) = @Response;
	#
	# products deleted from the catalog should not be tolerated at this point, so error out
	#
	if ($Status != $::SUCCESS)
		{
		return (@Response);
		}
	#
	# Process the optional ship and tax prompts
	#
	my (@DeleteDelimiters, @KeepDelimiters);
	my($sMessage, $pVarTable, $pDeleteDelimiters, $pKeepDelimiters, $pSelectTable);
	($Status, $sMessage, $pVarTable, $pDeleteDelimiters, $pKeepDelimiters, $pSelectTable) =
		ActinicOrder::DisplayPreliminaryInfoPhase($::FALSE); # get the ship charge phase  info
	if ($Status != $::SUCCESS)
		{
		return ($Status, $sMessage, $pVarTable, $pDeleteDelimiters, $pKeepDelimiters);
		}
	my (@Array1, @Array2, %SelectTable);			# append the shipping stuff to the rest of it
	@Array1 = %$pVarTable;
	@Array2 = %VariableTable;
	push (@Array1, @Array2);
	%VariableTable = @Array1;
	if (defined $pSelectTable)
		{
		@Array1 = %$pSelectTable;
		@Array2 = %SelectTable;
		push (@Array1, @Array2);
		%SelectTable = @Array1;
		}
	push (@DeleteDelimiters, @$pDeleteDelimiters);
	push (@KeepDelimiters, @$pKeepDelimiters);
	
	($Status, $sMessage, $pVarTable, $pDeleteDelimiters, $pKeepDelimiters) = # get the tax phase info
		ActinicOrder::DisplayTaxPhase($::FALSE);
	if ($Status != $::SUCCESS)
		{
		return ($Status, $sMessage, $pVarTable, $pDeleteDelimiters, $pKeepDelimiters);
		}
	@Array1 = %$pVarTable;								# append the tax stuff to the rest of it
	@Array2 = %VariableTable;
	push (@Array1, @Array2);
	%VariableTable = @Array1;
	push (@DeleteDelimiters, @$pDeleteDelimiters);
	push (@KeepDelimiters, @$pKeepDelimiters);
	
	($pDeleteDelimiters, $pKeepDelimiters) =		# get the information that tells us which prompts to remove
		ActinicOrder::ParseDelimiterStatus($::PRELIMINARYINFOPHASE);
	push (@DeleteDelimiters, @$pDeleteDelimiters);
	push (@KeepDelimiters, @$pKeepDelimiters);
		
	($pDeleteDelimiters, $pKeepDelimiters) =		# get the information that tells us which prompts to remove
		ActinicOrder::ParseDelimiterStatus($::TAXCHARGEPHASE);
	push (@DeleteDelimiters, @$pDeleteDelimiters);
	push (@KeepDelimiters, @$pKeepDelimiters);

	#######
	# Now we have all of the information that we need to proceed.  Check to see if the max quantity count = 
	# min quantity count.  If so and there are no prompts, automatically add it to the cart with quantity = min.
	#######
	# In this version confirmation page is always shown so the corresponding section is commented out
	#######
	my $nVarCount = (keys %$pVarTable) + (keys %$pSelectTable);
#	if (($$pProduct{"MIN_QUANTITY_ORDERABLE"} == $$pProduct{"MAX_QUANTITY_ORDERABLE"} || # if the quantities are equal or
#		  ($::g_sCurrentPage eq "PRODUCT" && $nMaxQuantity == 1)) && # this operation can only add one
#		 $$pProduct{"DATE_PROMPT"} eq "" &&				# and there is no date prompt
#		 $$pProduct{"OTHER_INFO_PROMPT"} eq "" &&		# and there is no other info prompt
#		 (!$$::g_pSetupBlob{TAX_AND_SHIP_EARLY} ||	# and either we are not taking tax and ship info early, or
#		 $nVarCount == 0))									# the tax and shipping phases are hidden
#		{
#		#
#		# Create a bounce page the emulates the order detail page.  To do this, build the CGI GET URL.
#		#
#		my ($sCgiUrl);
#		$sCgiUrl = sprintf('%sca%6.6d%s', $$::g_pSetupBlob{'CGI_URL'}, $$::g_pSetupBlob{'CGI_ID'},
#			$$::g_pSetupBlob{'CGI_EXT'});					# the cgi scrip URL
#		#
#		# Now add the parameters
#		#
#		my ($sGet);
#		$sGet = "?";
#		srand();
#		my ($Random) = rand();
#		$sGet .= "RANDOM=" . $Random;
#		@Response = ACTINIC::EncodeText($sPath, $::FALSE);
#		$sGet .= ($::g_InputHash{SHOP} ? '&SHOP=' . ACTINIC::EncodeText2($::g_InputHash{SHOP}, $::FALSE) : '');
#		$sGet .= "&PAGE=ORDERDETAIL";
#		@Response = ACTINIC::EncodeText(ACTINIC::GetReferrer(), $::FALSE);
#		$sGet .= "&REFPAGE=" . $Response[1];
#		@Response = ACTINIC::EncodeText($$pProduct{'REFERENCE'}, $::FALSE);
#		$sGet .= "&PRODREF=" . $Response[1];
#		if ($pProduct->{MIN_QUANTITY_ORDERABLE} == $pProduct->{MAX_QUANTITY_ORDERABLE}) # we are here because the min = max so there is no quantity choice
#			{
#			$sGet .= "&QUANTITY=" . $$pProduct{"MIN_QUANTITY_ORDERABLE"};
#			}
#		else													# we are here because the remaining count is 1 and there is no quantity choice
#			{
#			$sGet .= "&QUANTITY=1";
#			}
#		$sGet .= "&SID=" . $::g_InputHash{SID};
#		$sGet .= "&ACTION=" . ACTINIC::EncodeText2($::g_sConfirmButtonLabel, $::FALSE);
#		#
#		# now generate the page
#		#
#		my ($sRefPage, $sHTML);
#		$sRefPage = $sCgiUrl . $sGet;
#		@Response = ACTINIC::BounceToPagePlain(0, undef,
#			undef, \@::g_PageList, $::g_sWebSiteUrl, $::g_sContentUrl, $::g_pSetupBlob, $sRefPage, \%::g_InputHash);
#		if ($Response[0] != $::SUCCESS)
#			{
#			return (@Response);
#			}

#		return ($::SUCCESS, "", $Response[2], $sCartID);	# add the item to the cart
#		}

	$sLine = "<INPUT TYPE=HIDDEN NAME=PRODREF VALUE=\"$ProductRef\">";
	$sLine .= "<INPUT TYPE=HIDDEN NAME=SID VALUE=\"$::g_InputHash{SID}\">";

	#
	# Check if there are any variants
	#
	my $VariantList;
	if( $pProduct->{COMPONENTS} )
		{
		if( $::g_InputHash{PAGE} eq 'SHOPPINGCART' )
			{
			my ($pCartList, @EmptyArray);
			@Response = ActinicOrder::ReadCart($sCartID, ACTINIC::GetPath()); # read the shopping cart
			if ($Response[0] != $::SUCCESS)						# general error
				{
				$pCartList = \@EmptyArray;
				}
			else
				{
				$pCartList = $Response[2];
				}
			my $i = 0;
			my $pOrderDetail;
			foreach $pOrderDetail (@$pCartList)
				{
				my %CurrentItem = %$pOrderDetail;				# get the next item
				if( $CurrentItem{PRODUCT_REFERENCE} eq $ProductRef and $::g_InputHash{$i} ne '')
					{
					my $k;
					foreach $k (keys %CurrentItem)
						{
						if( $k =~ /^COMPONENT\_/ )
							{
							$VariantList->[$'] = $CurrentItem{$k};
							}
						}
					last;
					}
				$i++;
				}
			}
		else
			{
			my $sProdRefHTML;
			#
			# Get the variants and product ref HTML for this product
			#
			($VariantList, $sProdRefHTML) = ACTINIC::GetVariantList($ProductRef);
			$sLine .= $sProdRefHTML;
			}
		}
	$VariableTable{$::VARPREFIX."PRODUCTREF"} = $sLine; # add the product reference to the var table

	#######
	# add the product name to the html
	#######

	@Response = ACTINIC::ProcessEscapableText($$pProduct{"NAME"});# get the product name
	($Status, $sLine) = @Response;					# format the product name for HTML
	if ($Status != $::SUCCESS)
		{
		return (@Response);
		}
	
	$VariableTable{$::VARPREFIX."PRODUCTNAME"} = $sLine; # add the product name to the var table



	#######
	# add the product reference to the html
	#######
	@Response = FormatProductReference($ProductRef);
	($Status, $Message, $sLine) = @Response;
	if ($Status != $::SUCCESS)
		{
		return (@Response);
		}
	
	$VariableTable{$::VARPREFIX."DISPLAYPRODUCTREF"} = '&nbsp;' . $sLine; # add the product ref to the var table

	my (%Component, $pAcomponent, $sComponents);
	foreach $pAcomponent (@{$pProduct->{COMPONENTS}})
		{
		@Response = ActinicOrder::FindComponent($pAcomponent,$VariantList);
		($Status, %Component) = @Response;
		if ($Status != $::SUCCESS)
			{
			return ($Status,$Component{text});
			}
		if( $Component{quantity} > 0 )
			{
			$sComponents .= '<br>' . $pAcomponent->[0];
			if( $Component{text} )
				{
				$sComponents .= '&nbsp;-&nbsp;' . $Component{text};
				}
			if( $Component{code} )
				{
				#######
				# add the product reference to the html
				#######
				@Response = FormatProductReference($Component{code});
				($Status, $Message, $sLine) = @Response;
				if ($Status == $::SUCCESS)
					{
					$sComponents .= '&nbsp;' . $sLine; # add the component ref to the var table
					}
				}
			}
		}
	if ($$::g_pSetupBlob{"PROD_REF_COUNT"} > 0)			# if the product ref is to be displayed
		{
		$VariableTable{$::VARPREFIX."DISPLAYPRODUCTREF"} .= $sComponents;
		}
	else
		{
		$VariableTable{$::VARPREFIX."PRODUCTNAME"} .= $sComponents;
		}
	#
	# Need to work out which prices to show
	#
	my ($bShowRetailPrices, $bShowCustomerPrices, $nAccountSchedule) = ACTINIC::DeterminePricesToShow();
	#
	# See the price schedules and determine if the customer is allowed to buy
	#
	{
	my $sMessage;
	my $bNotAllowedToBuy = 0;
	if ('' ne $ACTINIC::B2B->Get('UserDigest'))
		{
		#
		# A registered user is not allowed to buy if:
		#
		if ( 	
				( 	#
					# The user is on retail price only and no retail price for the product
					#
					($::FALSE == $bShowCustomerPrices) &&
					($::TRUE == $bShowRetailPrices) &&
					(0 ==  scalar(@{$pProduct->{'PRICES'}->{$ActinicOrder::RETAILID}})) 
				)
				||	# OR
				(
					(	#
						# The user is on a price schedule and there is no price for this schedule
						#
						($::TRUE == $bShowCustomerPrices) &&
						(0 == scalar(@{$pProduct->{'PRICES'}->{$nAccountSchedule}})) 
					)
					&&	# AND 
					(	#
						# Either the user cannot order on retail price or no retail price included for the product
						#
						($::FALSE == $bShowRetailPrices) ||
						(0 == scalar(@{$pProduct->{'PRICES'}->{$ActinicOrder::RETAILID}}))
					)
				)
			)
			{
			$sMessage = ACTINIC::GetPhrase(-1, 351);	# 'This product is currently unavailable'
			$bNotAllowedToBuy = 1;
			}
		}
	else
		{
		#
		# An unregistered customer is not allowed to buy if the retail price is not available for the product
		#
		if (0 == scalar(@{$pProduct->{'PRICES'}->{$ActinicOrder::RETAILID}}))
			{
			$sMessage = ACTINIC::GetPhrase(-1,333);# 'This product is only avalable to registered customers'
			$bNotAllowedToBuy = 1;
			}
		}
	if ($bNotAllowedToBuy)								# unable to buy
		{
		my @Response = ReturnToLastPage(0, $sMessage);	# bounce back in the browser
		return @Response;
		}
	}
	
	$sLine = '';

	if (defined $$pProduct{PRICES})
		{
		my $sPriceLabelText = ACTINIC::GetPhrase(-1, 66);
		if($bShowRetailPrices && $bShowCustomerPrices)
			{
			my $sPriceLabel = ACTINIC::GetPhrase(-1, 294, $sPriceLabelText);
			#
			# Show the retail price
			#
			@Response = ActinicOrder::FormatSchedulePrices($pProduct, 
				$ActinicOrder::RETAILID, \$VariantList, $sPriceLabel);
			$sLine .= $Response[2];
			#
			# Show the dealer price
			#
			$sPriceLabel = ACTINIC::GetPhrase(-1, 293, $sPriceLabelText);
			@Response = ActinicOrder::FormatSchedulePrices($pProduct, 
				$nAccountSchedule, \$VariantList, $sPriceLabel);
			$sLine .= $Response[2];
			}
		elsif($bShowCustomerPrices)
			{
			@Response = ActinicOrder::FormatSchedulePrices($pProduct, 
				$nAccountSchedule, \$VariantList, $sPriceLabelText);
			$sLine = $Response[2];
			}
		else
			{
			@Response = ActinicOrder::FormatSchedulePrices($pProduct, 
				1, \$VariantList, $sPriceLabelText);
			$sLine = $Response[2];
			}
		}

	$VariableTable{$::VARPREFIX."PRODUCTPRICE"} = $sLine; # add the product price to the var table

	#######
	# add the quantity prompt.  if the min=max, hard code the quantity.  otherwise, offer the prompt
	#######
   if ($$pProduct{"MIN_QUANTITY_ORDERABLE"} == $$pProduct{"MAX_QUANTITY_ORDERABLE"} || # nothing to edit - so hard code the quantity
		 ($::g_sCurrentPage eq "PRODUCT" && $nMaxQuantity == 1))
		{
		if ($nMaxQuantity == 1)
			{
			$VariableTable{$::VARPREFIX."QUANTITY"} = '1' . # hard code the quantity
				"<INPUT TYPE=HIDDEN NAME=QUANTITY VALUE=\"1\">";
			}
		else
			{
			$VariableTable{$::VARPREFIX."QUANTITY"} = $$pProduct{"MIN_QUANTITY_ORDERABLE"} . # hard code the quantity
				"<INPUT TYPE=HIDDEN NAME=QUANTITY VALUE=\"" . $$pProduct{"MIN_QUANTITY_ORDERABLE"} . "\">";
			}
		}
	else														# the user can specify
		{
		#
		# Determine how many more can be ordered.  Default to the minimum amount orderable given the circumstances:
		# If the cart already contains some of this item, default to just adding one more.  If not, default to the
		# minimum quantity orderable.  Note that this check only applies when items are being added to the cart.
		# For edits, etc. just offer the minimum quantity orderable because it is overwritten by the calling routines.
		#
		my $nDefaultQuantity = $pProduct->{MIN_QUANTITY_ORDERABLE};

		if ($::g_sCurrentPage eq "PRODUCT")			# if this is the first viewing of the OD page,
			{
			if ($nMaxQuantity != $pProduct->{MAX_QUANTITY_ORDERABLE})	# if something is already in the cart
				{
				$nDefaultQuantity = 1;					# set the minimum incremental addition
				}
			}

		$VariableTable{$::VARPREFIX."QUANTITY"} = "<INPUT TYPE=TEXT NAME=QUANTITY VALUE=\"" .
		   $nDefaultQuantity . "\" SIZE=6 MAXLENGTH=10>";
		}

	#######
	# add the date prompt (if any) to the html
	#######

	my ($sDatePrompt);
	$sDatePrompt = $$pProduct{"DATE_PROMPT"};		# get the prompt text
	$sLine = "";
	if (length $sDatePrompt > 0)						# if there is a date prompt, print the message and format the prompt
		{
		my (@TimeList);
		@TimeList = localtime(time);					# get the time

		$sLine = "<P>".$sDatePrompt."<BR>\n";		# add the prompt to the html
		$sLine .= "<SELECT NAME=DAY  SIZE=1>\n";	# add the day drop down list

		my ($nDefaultDay, $nDefaultMonth, $nDefaultYear) =
			($TimeList[3], $TimeList[4]+1, $TimeList[5]+1900);
		if ($#Date > 0)									# if a default date was supplied
			{
			if (defined $Date[0])						# use the default day
				{
				$nDefaultDay = $Date[0];
				}
			if (defined $Date[1])						# use the default day
				{
				$nDefaultMonth = $Date[1];
				}
			if (defined $Date[2])						# use the default day
				{
				$nDefaultYear = $Date[2];
				}
			}

		my ($nDay);
		for ($nDay=1; $nDay <= 31; $nDay++)	# add the days
			{
			if ($nDay == $nDefaultDay)					# if this is the current day,
				{
				$sLine .= "\t<OPTION SELECTED>$nDay\n";	# add it to the list and select it
				}
			else												# otherwise
				{
				$sLine .= "\t<OPTION>$nDay\n";		# just add it to the list
				}
			}
		
		$sLine .= "</SELECT>\n";						# close the list
		
		$sLine .= "<SELECT NAME=MONTH  SIZE=1>\n"; # add the month drop down list
		
		my ($nMonth);
		for ($nMonth=1; $nMonth < 13; $nMonth++)	# add the month
			{
			if ($nMonth == $nDefaultMonth)			# if this is the current month,
				{
				$sLine .= "\t<OPTION SELECTED>" . $::g_InverseMonthMap{$nMonth} . "\n";	# add it to the list and select it
				}
			else												# otherwise
				{
				$sLine .= "\t<OPTION>" . $::g_InverseMonthMap{$nMonth} . "\n";		# just add it to the list
				}
			}
		$sLine .= "</SELECT>\n";						# close the list
		
		$sLine .= "<SELECT NAME=YEAR  SIZE=1>\n"; # add the year drop down list
		
		my ($nStartYear, $nYear);
		$nStartYear = $TimeList[5] + 1900 - 7;		# get the start year (today - 7 years)
		
		for ($nYear = $nStartYear; $nYear < $nStartYear + 21; $nYear++)	# add the years
			{
			if ($nYear == $nDefaultYear)				# if this is the current year,
				{
				$sLine .= "\t<OPTION SELECTED>$nYear\n";	# add it to the list and select it
				}
			else												# otherwise
				{
				$sLine .= "\t<OPTION>$nYear\n";		# just add it to the list
				}
			}		
		$sLine .= "</SELECT>\n";						# close the list
		
		$sLine .= "<BR>\n";
		}
	$VariableTable{$::VARPREFIX."DATEINPUT"} = $sLine; # add the date prompt (if any) to the var table
	
	#######
	# add the info prompt (if any) to the html
	#######

	my ($sInfoPrompt);
	$sInfoPrompt = $$pProduct{"OTHER_INFO_PROMPT"};
	$sLine = "";
	if (length $sInfoPrompt > 0)						# if there is an info prompt, print the message and format the prompt
		{
		$sLine = "<P>".$sInfoPrompt."<BR>\n";		# add the prompt to the html
		$sLine .= "<INPUT TYPE=TEXT NAME=INFOINPUT SIZE=60 MAXLENGTH=1000>\n";	# add the text field to the list
		}
	$VariableTable{$::VARPREFIX."INFOINPUT"} = $sLine; # add the info prompt (if any) to the var table
	#
	# Presnet: we may not want to display the cart contents until the item has been added
	#
	if (defined $$::g_pSetupBlob{'SUPPRESS_CART_WITH_CONFIRM'} &&
		$$::g_pSetupBlob{'SUPPRESS_CART_WITH_CONFIRM'})
		{
		$VariableTable{$::VARPREFIX.'THEORDERDETAILS'} = ""; # don't display the cart contents
		}
	else
		{
		#
		# Now display a summary of the shopping cart
		#
		my ($pCartList, @EmptyArray);
		@Response = ActinicOrder::ReadCart($sCartID, $sPath); # read the shopping cart
		if ($Response[0] != $::SUCCESS)						# general error
			{
			$pCartList = \@EmptyArray;
			}
		else
			{
			$pCartList = $Response[2];
			}
		#
		# if the cart contains any items, display it.  Otherwise, skip it
		#
		my $sOrderDetailHTML;
		if ($#{$pCartList} >= 0)
			{
			@Response = ActinicOrder::GenerateShoppingCartLines($pCartList);
			if ($Response[0] != $::SUCCESS)
				{
				return (@Response);
				}
			$sOrderDetailHTML = $Response[2];
			}
		$VariableTable{$::VARPREFIX.'THEORDERDETAILS'} = $sOrderDetailHTML; # add the order lines to the reciept
		}
	
	#######
	# customize the file
	#######
	@Response = ACTINIC::TemplateFile($sPath."ODTemplate.html", \%VariableTable);	# customize the file
	my ($sHTML);
	($Status, $Message, $sHTML) = @Response;
	if ($Status != $::SUCCESS)
		{
		return (@Response);
		}

	#######
	# make the file references point to the correct directory
	#######
	if( !$ACTINIC::B2B->Get('UserDigest') )
		{
		@Response = ACTINIC::MakeLinksAbsolute($sHTML, $::g_sWebSiteUrl, $::g_sContentUrl);
		}
	else
		{
		my $sBaseFile = $ACTINIC::B2B->Get('BaseFile');
		my $smPath = ($sBaseFile) ? $sBaseFile : $::g_sContentUrl;
		my $sCgiUrl = $::g_sAccountScript;
		$sCgiUrl   .= ($::g_InputHash{SHOP} ? '?SHOP=' . ACTINIC::EncodeText2($::g_InputHash{SHOP}, $::FALSE) . '&': '?');
		$sCgiUrl   .= 'PRODUCTPAGE=';
		@Response = ACTINIC::MakeLinksAbsolute($sHTML, $sCgiUrl, $smPath);
		}

	($Status, $Message, $sHTML) = @Response;
	if ($Status != $::SUCCESS)
		{
		return (@Response);
		}
	#
	# remove unused form blocks
	#
	my ($sDelimiter);
	foreach $sDelimiter (@DeleteDelimiters)			# for each delimited section that is to be deleted
		{
		$sHTML =~ s/$::DELPREFIX$sDelimiter(.*?)$::DELPREFIX$sDelimiter//gs;	# delete it (/s removes the \n limitation of .)
		}
	#
	# remove unused delimiters
	#
	foreach $sDelimiter (@KeepDelimiters)				# for each delimiter that is not used
		{
		$sHTML =~ s/$::DELPREFIX$sDelimiter//gs;			# delete it
		}
	#
	# perform special handling of <SELECT> form field defaults since it is too difficult
	#	to do with the standard TemplateFile architecture
	#
	my ($sSelectName, $sDefaultOption);
	while ( ($sSelectName, $sDefaultOption) = each %$pSelectTable)
		{
		$sHTML =~ s/(<\s*SELECT[^>]+?NAME\s*=\s*("|')?$sSelectName.+?)<OPTION\s+VALUE\s*=\s*("|')?$sDefaultOption("|')?\s*>/$1<OPTION SELECTED VALUE="$sDefaultOption">/is;
		}
	#
	# remove the checkout now button if we are in the edit screen
	#
	if ($bEditMode)
		{
		my $sCheckOutNow = ACTINIC::GetPhrase(-1, 184);
		$sHTML =~ s/<INPUT[^>]*?$sCheckOutNow[^>]*?>//i;
		}
	
	return ($::SUCCESS, "", $sHTML, $sCartID);
	}

##############################################################################################################
#																		
# Command Processing - End
#
##############################################################################################################

##############################################################################################################
#																		
# Text Processing - Begin
#
##############################################################################################################

#######################################################
#																		
# FormatProductReference - format the product reference
#
# Params:	$_[0] - the product reference
#
# Returns:	($ReturnCode, $Error, $sFormattedText, 0)
#				if $ReturnCode = $::FAILURE, the operation failed
#					for the reason specified in $Error
#				Otherwise everything is OK
#
#######################################################

sub FormatProductReference
	{
	if (!defined $_[0])
		{
		return ($::FAILURE, ACTINIC::GetPhrase(-1, 12, 'FormatProductReference'), 0, 0);
		}

	my ($sProdRef, $sFormat, $sLine, @Response, $Status, $Message);
	$sProdRef = $_[0];									# retrieve the product ref from the argument list
	$sLine = "";
	
	if ($$::g_pSetupBlob{"PROD_REF_COUNT"} > 0)			# if the product ref is to be displayed
		{
		$sLine = ACTINIC::GetPhrase(-1, 65, $sProdRef);		# format the message

		@Response = ACTINIC::EncodeText($sLine);	# convert the special characters to their hex codes
		($Status, $sLine) = @Response;
		if ($Status != $::SUCCESS)
			{
			return (@Response);
			}
		
		$sLine = "<FONT SIZE=-2>" . $sLine . "</FONT>";
		}
	return ($::SUCCESS, "", $sLine, 0);
	}

##############################################################################################################
#																		
# Text Processing - End
#
##############################################################################################################

##############################################################################################################
#																		
# Initialization and Input - Begin
#
##############################################################################################################

#######################################################
#																		
# Init - initialize the script
#
#######################################################

sub Init
	{
	$::prog_name = "SHOPCART";							# Program Name 
	$::prog_name = $::prog_name;
	$::prog_ver = '$Revision: 191 $ ';				# program version
	$::prog_ver = substr($::prog_ver, 11);			# strip the revision information
	$::prog_ver =~ s/ \$//;								# and the trailers

	my (@Response, $Status, $Message);
	
	@Response = ReadAndParseInput();					# read the input from the CGI call
	($Status, $Message) = @Response;					# parse the response
	if ($Status != $::SUCCESS)
		{
		ACTINIC::ReportError($Message, ACTINIC::GetPath());
		}
	
	@Response = ReadAndParseBlobs();					# read the catalog blobs
	($Status, $Message) = @Response;					# parse the response
	if ($Status != $::SUCCESS)
		{
		ACTINIC::ReportError($Message, ACTINIC::GetPath());
		}
	#
	# read the prompt blob
	#
	@Response = ACTINIC::ReadPromptFile(ACTINIC::GetPath());
	if ($Response[0] != $::SUCCESS)
		{
		ACTINIC::ReportError($Response[1], ACTINIC::GetPath());
		}

	$ACTINIC::B2B->Set('UserDigest',ACTINIC::CAccFindUser());
	#
	# initialize some global hashes (must come after prompt file)
	#
	ACTINIC::InitMonthMap();
	# PRESNET
	#
	# initialize some Presnet hashes (must come after prompt file)
	#
	if(!defined $::g_InputHash{"ACTION"})
		{
		if(defined $::g_InputHash{"ACTION_CONFIRM.x"})
			{
			$::g_InputHash{"ACTION"} = $::g_sConfirmButtonLabel;
			}
		elsif(defined $::g_InputHash{"ACTION_CANCEL.x"})
			{
			$::g_InputHash{"ACTION"} = $::g_sCancelButtonLabel;
			}
		elsif(defined $::g_InputHash{"ACTION_BUYNOW.x"})
			{
			$::g_InputHash{"ACTION"} = ACTINIC::GetPhrase(-1, 184);
			}
		elsif (defined $$::g_pSetupBlob{'EDIT_IMG'} && $$::g_pSetupBlob{'EDIT_IMG'} ne '')
			{
			my $sKey;
			foreach $sKey (keys(%::g_InputHash))
				{
				if ($sKey =~ /^ACTION_EDIT(\d+)\.x/)
					{
					$::g_InputHash{$1} = $::g_sEditButtonLabel;
					}
				elsif ($sKey =~ /^ACTION_REMOVE(\d+)\.x/)
					{
					$::g_InputHash{$1} = $::g_sRemoveButtonLabel;
					}
				}
			}
		}
	# PRESNET
	}

#######################################################
#																		
# ReadAndParseInput - read the input and parse it
#
# Expects:	$ENV to be defined
#
# Affects:	@::g_PageList - global list of pages visited
#
# Returns:	($ReturnCode, $Error)
#				if $ReturnCode = $::FAILURE, the operation failed
#					for the reason specified in $Error
#				Otherwise everything is OK
#
#######################################################

sub ReadAndParseInput
	{
	my ($status, $message, $temp);
	($status, $message, $::g_OriginalInputData, $temp, %::g_InputHash) = ACTINIC::ReadAndParseInput();
	if ($status != $::SUCCESS)
		{
		return ($status, $message, 0, 0);
		}

	#
	# parse the ref page list
	#
	($status, $message, @::g_PageList) = ACTINIC::ProcessReferencePageData(%::g_InputHash);
	if ($status != $::SUCCESS)
		{
		return ($status, $message, 0, 0);
		}

	#######
	# retrieve the web site url
	#######
	($status, $message, $::g_sWebSiteUrl, $::g_sContentUrl) = ACTINIC::GetWebSiteURL(@::g_PageList);
	if ($status != $::SUCCESS)
		{
		return ($status, $message, 0, 0);
		}
	
	return ($::SUCCESS, "", 0, 0);
	}


#######################################################
#																		
# ReadAndParseBlobs - read the blobs and store them
#	in global data structures
#
# Expects:	%::g_InputHash - the input hash table should
#					be defined
#
# Affects:	%::g_BillContact - the invoice contact info
#				%::g_ShipContact - the delivery contact info
#				%::g_ShipInfo - the shipping info
#				%::g_TaxInfo - the tax exemption info
#				%::g_GeneralInfo - the general info page info
#				%g_PaymentInfo - the payment details
#
# Returns:	($ReturnCode, $Error)
#				if $ReturnCode = $::FAILURE, the operation failed
#					for the reason specified in $Error
#				Otherwise everything is OK
#
#######################################################

sub ReadAndParseBlobs
	{
	my ($Status, $Message, @Response, $sPath);

	$sPath = ACTINIC::GetPath();						# get the path to the web site

	@Response = ACTINIC::ReadCatalogFile($sPath); # read the catalog blob
	($Status, $Message) = @Response; # parse the response
	if ($Status != $::SUCCESS)							# on error, bail
		{
		return (@Response);
		}
	
	@Response = ACTINIC::ReadSetupFile($sPath);	# read the setup
	($Status, $Message) = @Response;
	if ($Status != $::SUCCESS)
		{
		return (@Response);
		}

	@Response = ACTINIC::ReadLocationsFile($sPath);	# read the locations
	($Status, $Message) = @Response;
	if ($Status != $::SUCCESS)
		{
		return (@Response);
		}
	#
	# read the cart ID
	#
	my ($sCartId);
	@Response = ActinicOrder::GetCartID(ACTINIC::GetPath()); # retrieve the cart ID
	($Status, $Message, $sCartId) = @Response;
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}	
	#
	# read the checkout status
	#
	my ($pBillContact, $pShipContact, $pShipInfo, $pTaxInfo, $pGeneralInfo, $pPaymentInfo, $pLocationInfo);
	@Response = ActinicOrder::RetrieveCheckoutStatus($sPath, $sCartId);
	if ($Response[0] != $::SUCCESS)
		{
		return (@Response);
		}
	($Status, $Message, $pBillContact, $pShipContact, $pShipInfo, $pTaxInfo, $pGeneralInfo, $pPaymentInfo, $pLocationInfo) = @Response;
	%::g_BillContact = %$pBillContact;					# copy the hashes to global tables
	%::g_ShipContact = %$pShipContact;
	%::g_ShipInfo		= %$pShipInfo;
	%::g_TaxInfo		= %$pTaxInfo;
	%::g_GeneralInfo = %$pGeneralInfo;
	%::g_PaymentInfo = %$pPaymentInfo;
	%::g_LocationInfo = %$pLocationInfo;

	#
	# read the tax blob
	#
	@Response = ACTINIC::ReadTaxSetupFile($sPath);
	if ($Response[0] != $::SUCCESS)
		{
		return (@Response);
		}
	ActinicOrder::ParseAdvancedTax();
	return ($::SUCCESS, "");
	}

##############################################################################################################
#																		
# Initialization and Input - End
#
##############################################################################################################

##############################################################################################################
#																		
# Output - Begin
#
##############################################################################################################

#######################################################
#																		
# ReturnToLastPage - bounce the browser to the previous
#	page.  NOTE: this is a wrapper for the ACTINIC
#	package version.  It prevents a bunch of duplicate
#	work
#
# Params:	[0] - bounce delay
#				[1] - string to add to display
#				[2] - optional page title.  If the page
#						title exists, the page is formatted
#						using the bounce template
#
# Expects:	%::g_InputHash should be defined
#
# Returns:	($ReturnCode, $Error, $sHTML, 0)
#				if $ReturnCode = $::FAILURE, the operation failed
#					for the reason specified in $Error
#				Otherwise everything is OK
#				$sHTML - the HTML of the bounce page
#
#######################################################

sub ReturnToLastPage
	{
	my ($nDelay, $sMessage, $sTitle);
	($nDelay, $sMessage, $sTitle) = @_;
	if (!defined $sTitle)
		{
		$sTitle = "";
		}
	
	return (ACTINIC::ReturnToLastPage($nDelay, $sMessage, $sTitle,
												 \@::g_PageList, $::g_sWebSiteUrl,
												 $::g_sContentUrl, $::g_pSetupBlob, %::g_InputHash));
	}

#######################################################
#																		
# GroomHTML - Display HTML with header/footer and background
#	NOTE: this is a wrapper for the ACTINIC
#	package version.  It prevents a bunch of duplicate
#	work  (Presnet).
#
# Params:	[0] - string to add to display
#				[1] - optional page title.  If the page
#						title exists, the page is formatted
#						using the bounce template
#
# Expects:	%::g_InputHash should be defined
#
# Returns:	($ReturnCode, $Error, $sHTML, 0)
#				if $ReturnCode = $::FAILURE, the operation failed
#					for the reason specified in $Error
#				Otherwise everything is OK
#				$sHTML - the HTML of the page
#
#######################################################

sub GroomHTML
	{
	my ($sMessage, $sTitle);
	($sMessage, $sTitle) = @_;
	if (!defined $sTitle)
		{
		$sTitle = "";
		}
	
	return (ACTINIC::GroomHTML($sMessage, $sTitle,
										 \@::g_PageList, $::g_sWebSiteUrl,
										 $::g_sContentUrl, $::g_pSetupBlob, %::g_InputHash));
	}

#######################################################
#																		
# PrintPage - Print the HTML to the browser.  NOTE:
#	this is just a wrapper for the ACTINIC package
#	function.
#
# Params:	[0] - HTML
#				[1] - Cookie (optional)
#				[2] - cache flag (optional - default no-cache)
#
#######################################################

sub PrintPage
	{
	my $sHTML = $_[0];
	return (
			  ACTINIC::UpdateDisplay($sHTML, $::g_OriginalInputData,
											\@::g_PageList, $_[1], $_[2])
			 );
	}

#######################################################
#																		
# AddLink - Formats the HTML for a <A> link  (Presnet)
#
# Params:	[0] - URL
#				[1] - Text
#
# Expects:	%::g_InputHash should be defined
#
# Returns:	($ReturnCode, $Error, $sHTML, 0)
#				if $ReturnCode = $::FAILURE, the operation failed
#					for the reason specified in $Error
#				Otherwise everything is OK
#				$sHTML - the HTML of the link
#
#######################################################

sub AddLink
	{
	my ($sURL, $sTarget, $sImage, $sAlt, $sText) = @_;
	my ($sHTML);
	#
	# add the opening tag
	#
	$sHTML .= "<A HREF=\"";
	$sHTML .= $sURL . "\"";
	#
	# add the target
	#
	$sHTML .= " TARGET=\"" . $sTarget . "\">";
	#
	# add the image
	#
	if (defined $sImage && $sImage ne '' && ACTINIC::CheckFileExists($sImage, ACTINIC::GetPath()))
		{
		$sHTML .= "<IMG SRC=\"" . $sImage ."\" ALT=\"" . $sAlt . "\" BORDER=0><BR>";
		}
	#
	# add the text label
	#
	$sHTML .= "" . $sText . "</A><BR>";
	return($::SUCCESS, "", $sHTML);
	}

#######################################################
#																		
# DisplayCartWithLinks - Gets the HTML for displaying
#		the cart contents with links to continue shopping
#		and going to checkout (Presnet).
#
# Params:	[0] - Cart ID
#				[1] - Page Title
#
# Expects:	%::g_InputHash should be defined
#
# Returns:	($ReturnCode, $Error, $sHTML, 0)
#				if $ReturnCode = $::FAILURE, the operation failed
#					for the reason specified in $Error
#				Otherwise everything is OK
#				$sHTML - the HTML of the link
#
#######################################################

sub DisplayCartWithLinks
	{
	#
	# Now display a summary of the shopping cart
	#
	my ($sCartID, $sPageTitle, $pCartList, @EmptyArray, $sStartButton);
	my ($Status, $Message, $sHTML, @Response);
	($sCartID, $sPageTitle) = @_;
	@Response = ActinicOrder::ReadCart($sCartID, ACTINIC::GetPath()); # read the shopping cart
	if ($Response[0] != $::SUCCESS)						# general error
		{
		$pCartList = \@EmptyArray;
		}
	else
		{
		$pCartList = $Response[2];
		}
	@Response = ActinicOrder::GenerateShoppingCartLines($pCartList);
	if ($Response[0] != $::SUCCESS)
		{
		return (@Response);
		}
	$sHTML .= $Response[2];
	#
	# we want to get the refering page ignoring the previous script call
	#
	my ($sRefPage, $sPathArg, $sRefPageArg);
	#
	# save the confirmation script call
	#
	$sRefPage = $::g_PageList[-2];

	#
	# Add the path to catalog.
	#
	@Response = ACTINIC::EncodeText(ACTINIC::GetPath(), $::FALSE);
	$sPathArg = ($::g_InputHash{SHOP} ? '&SHOP=' . ACTINIC::EncodeText2($::g_InputHash{SHOP}, $::FALSE) : '');
	#
	# use the section page for use as the referer
	#
	@Response = ACTINIC::EncodeText($sRefPage, $::FALSE);
	$sRefPageArg .= "&REFPAGE=" . $Response[1];
	#
	# set up a table with the links
	#
	$sHTML .= "<BR>";
	$sHTML .= "<TABLE BORDER=0 WIDTH=600><TR><TD WIDTH=\"33%\" ALIGN=\"LEFT\">";
	#
	# add the continue shopping link to the HTML
	#
	my ($sLinkHTML, $sTarget);
	($Status, $Message, $sLinkHTML) = AddLink($sRefPage, "_self", 	$$::g_pSetupBlob{'CONTINUE_SHOP'},  
		"Continue Shopping", "");						# parse the response
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}
	$sHTML .= $sLinkHTML;								# add to page
	#
	# add table divider
	#
	$sHTML .= "</TD><TD WIDTH=\"33%\" ALIGN=\"CENTER\">";

	#
	# add the edit cart link to the HTML
	#
	#
	# Build the cart script URL.
	#
	my $sCartURL = sprintf('%sca%6.6d%s', $$::g_pSetupBlob{'CGI_URL'}, $$::g_pSetupBlob{'CGI_ID'},
		$$::g_pSetupBlob{'CGI_EXT'});					# the cart script URL
	$sCartURL .= "?ACTION=SHOWCART" . $sPathArg . $sRefPageArg;

	($Status, $Message, $sLinkHTML) = AddLink($sCartURL, "_self", 	$$::g_pSetupBlob{'EDIT_CART'},  
		"Show Cart", "");									# parse the response
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}
	$sHTML .= $sLinkHTML;								# add to page
	#
	# add table divider
	#
	$sHTML .= "</TD><TD WIDTH=\"33%\" ALIGN=\"RIGHT\">";

	#
	# build the link for proceed to checkout
	#
	my ($sCheckoutUrl);
	#
	# Build the order script URL.
	#
	$sCheckoutUrl = sprintf('%sos%6.6d%s', $$::g_pSetupBlob{'CGI_URL'}, $$::g_pSetupBlob{'CGI_ID'},
		$$::g_pSetupBlob{'CGI_EXT'});					# the cgi script URL
	#
	# Add the arguments.
	#
	$sCheckoutUrl .= "?";
	$sStartButton = ACTINIC::GetPhrase(-1, 113);
	@Response = ACTINIC::EncodeText($sStartButton, $::FALSE);

	$sCheckoutUrl .= "ACTION=" . $Response[1];	# add the action	
	#
	# Add the path to catalog and refpage.
	#
	$sCheckoutUrl .= $sPathArg;	
	#
	# if catalog is framed the target should be the parent frame
	#
	if ($$::g_pSetupBlob{UNFRAMED_CHECKOUT})		# if we are to exit frames for checkout
		{
		$sTarget = "_parent";
		#
		# to ensure we restore the frame we substitute the referring page 
		# with the FRAMESET page
		#
		@Response = ACTINIC::GetCatalogBasePageName(ACTINIC::GetPath());
		if($Response[0] != $::SUCCESS)				# if we failed to get the page name
			{
			$sCheckoutUrl .= $sRefPageArg;			# use the section page and live with the bug	
			}
		else													# we got the base page name
			{
			#
			# make the reference page absolute if required
			#
			my $sAbsBasePageURL = ($Response[2] =~ m#http.*://#) ? $Response[2] : $::g_sWebSiteUrl . $Response[2];
			#
			# add the encoded argument to the URL as the REF page
			#
			@Response = ACTINIC::EncodeText($sAbsBasePageURL, $::FALSE);
			$sCheckoutUrl .= "&REFPAGE=" . $Response[1];	
			}
		}
	else
		{
		$sTarget = "_self";
		#
		# Add the path to refpage.
		#
		$sCheckoutUrl .= $sRefPageArg;	
		}
	#
	# format the link
	#
	($Status, $Message, $sLinkHTML) = AddLink($sCheckoutUrl, $sTarget, $$::g_pSetupBlob{'PROCEED_CHECKOUT'}, 
		"Proceed to Checkout", "");					# parse the response
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}
	$sHTML .= $sLinkHTML;								# add to page

	$sHTML .= "</TD></TR></TABLE>";					# add closing tags for table
	#
	# format the HTML as a catalog page
	#
	@Response = GroomHTML("<B>" .
		$sHTML . "</B>",
		$sPageTitle);										# bounce back in the broswer
	($Status, $Message, $sHTML) = @Response;		# parse the response
	if ($Status != $::SUCCESS)							# error out
		{
		return (@Response);
		}
	return($::SUCCESS, "", $sHTML);
	}

##############################################################################################################
#																		
# Output - End
#
##############################################################################################################
